/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportPhoneNumberResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ImportPhoneNumberResponse> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberId").getter(ImportPhoneNumberResponse.getter(ImportPhoneNumberResponse::phoneNumberId)).setter(ImportPhoneNumberResponse.setter(Builder::phoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberArn").getter(ImportPhoneNumberResponse.getter(ImportPhoneNumberResponse::phoneNumberArn)).setter(ImportPhoneNumberResponse.setter(Builder::phoneNumberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD, PHONE_NUMBER_ARN_FIELD));
    private final String phoneNumberId;
    private final String phoneNumberArn;

    private ImportPhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberId = builder.phoneNumberId;
        this.phoneNumberArn = builder.phoneNumberArn;
    }

    public final String phoneNumberId() {
        return this.phoneNumberId;
    }

    public final String phoneNumberArn() {
        return this.phoneNumberArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportPhoneNumberResponse)) {
            return false;
        }
        ImportPhoneNumberResponse other = (ImportPhoneNumberResponse)((Object)obj);
        return Objects.equals(this.phoneNumberId(), other.phoneNumberId()) && Objects.equals(this.phoneNumberArn(), other.phoneNumberArn());
    }

    public final String toString() {
        return ToString.builder((String)"ImportPhoneNumberResponse").add("PhoneNumberId", (Object)this.phoneNumberId()).add("PhoneNumberArn", (Object)this.phoneNumberArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberId()));
            }
            case "PhoneNumberArn": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportPhoneNumberResponse, T> g) {
        return obj -> g.apply((ImportPhoneNumberResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String phoneNumberId;
        private String phoneNumberArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportPhoneNumberResponse model) {
            super(model);
            this.phoneNumberId(model.phoneNumberId);
            this.phoneNumberArn(model.phoneNumberArn);
        }

        public final String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getPhoneNumberArn() {
            return this.phoneNumberArn;
        }

        public final void setPhoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
        }

        @Override
        public final Builder phoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
            return this;
        }

        @Override
        public ImportPhoneNumberResponse build() {
            return new ImportPhoneNumberResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportPhoneNumberResponse> {
        public Builder phoneNumberId(String var1);

        public Builder phoneNumberArn(String var1);
    }
}

