/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.EvaluationFormSummary;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsRequest;
import software.amazon.awssdk.services.connect.model.ListEvaluationFormsResponse;

public class ListEvaluationFormsIterable
implements SdkIterable<ListEvaluationFormsResponse> {
    private final ConnectClient client;
    private final ListEvaluationFormsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEvaluationFormsIterable(ConnectClient client, ListEvaluationFormsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEvaluationFormsResponseFetcher();
    }

    public Iterator<ListEvaluationFormsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EvaluationFormSummary> evaluationFormSummaryList() {
        Function<ListEvaluationFormsResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluationFormSummaryList() != null) {
                return response.evaluationFormSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEvaluationFormsResponseFetcher
    implements SyncPageFetcher<ListEvaluationFormsResponse> {
        private ListEvaluationFormsResponseFetcher() {
        }

        public boolean hasNextPage(ListEvaluationFormsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEvaluationFormsResponse nextPage(ListEvaluationFormsResponse previousPage) {
            if (previousPage == null) {
                return ListEvaluationFormsIterable.this.client.listEvaluationForms(ListEvaluationFormsIterable.this.firstRequest);
            }
            return ListEvaluationFormsIterable.this.client.listEvaluationForms((ListEvaluationFormsRequest)((Object)ListEvaluationFormsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

