/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowSummary;
import software.amazon.awssdk.services.connect.model.ListContactFlowsRequest;
import software.amazon.awssdk.services.connect.model.ListContactFlowsResponse;

public class ListContactFlowsPublisher
implements SdkPublisher<ListContactFlowsResponse> {
    private final ConnectAsyncClient client;
    private final ListContactFlowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactFlowsPublisher(ConnectAsyncClient client, ListContactFlowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactFlowsPublisher(ConnectAsyncClient client, ListContactFlowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactFlowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactFlowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactFlowSummary> contactFlowSummaryList() {
        Function<ListContactFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowSummaryList() != null) {
                return response.contactFlowSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactFlowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactFlowsResponseFetcher
    implements AsyncPageFetcher<ListContactFlowsResponse> {
        private ListContactFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactFlowsResponse> nextPage(ListContactFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListContactFlowsPublisher.this.client.listContactFlows(ListContactFlowsPublisher.this.firstRequest);
            }
            return ListContactFlowsPublisher.this.client.listContactFlows((ListContactFlowsRequest)((Object)ListContactFlowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

