/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse;

public class GetCurrentUserDataIterable
implements SdkIterable<GetCurrentUserDataResponse> {
    private final ConnectClient client;
    private final GetCurrentUserDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCurrentUserDataIterable(ConnectClient client, GetCurrentUserDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCurrentUserDataResponseFetcher();
    }

    public Iterator<GetCurrentUserDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetCurrentUserDataResponseFetcher
    implements SyncPageFetcher<GetCurrentUserDataResponse> {
        private GetCurrentUserDataResponseFetcher() {
        }

        public boolean hasNextPage(GetCurrentUserDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCurrentUserDataResponse nextPage(GetCurrentUserDataResponse previousPage) {
            if (previousPage == null) {
                return GetCurrentUserDataIterable.this.client.getCurrentUserData(GetCurrentUserDataIterable.this.firstRequest);
            }
            return GetCurrentUserDataIterable.this.client.getCurrentUserData((GetCurrentUserDataRequest)((Object)GetCurrentUserDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

