/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentInfo> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AgentInfo.getter(AgentInfo::id)).setter(AgentInfo.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Instant> CONNECTED_TO_AGENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ConnectedToAgentTimestamp").getter(AgentInfo.getter(AgentInfo::connectedToAgentTimestamp)).setter(AgentInfo.setter(Builder::connectedToAgentTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedToAgentTimestamp").build()}).build();
    private static final SdkField<Integer> AGENT_PAUSE_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AgentPauseDurationInSeconds").getter(AgentInfo.getter(AgentInfo::agentPauseDurationInSeconds)).setter(AgentInfo.setter(Builder::agentPauseDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentPauseDurationInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CONNECTED_TO_AGENT_TIMESTAMP_FIELD, AGENT_PAUSE_DURATION_IN_SECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Instant connectedToAgentTimestamp;
    private final Integer agentPauseDurationInSeconds;

    private AgentInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.connectedToAgentTimestamp = builder.connectedToAgentTimestamp;
        this.agentPauseDurationInSeconds = builder.agentPauseDurationInSeconds;
    }

    public final String id() {
        return this.id;
    }

    public final Instant connectedToAgentTimestamp() {
        return this.connectedToAgentTimestamp;
    }

    public final Integer agentPauseDurationInSeconds() {
        return this.agentPauseDurationInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedToAgentTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentPauseDurationInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentInfo)) {
            return false;
        }
        AgentInfo other = (AgentInfo)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.connectedToAgentTimestamp(), other.connectedToAgentTimestamp()) && Objects.equals(this.agentPauseDurationInSeconds(), other.agentPauseDurationInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"AgentInfo").add("Id", (Object)this.id()).add("ConnectedToAgentTimestamp", (Object)this.connectedToAgentTimestamp()).add("AgentPauseDurationInSeconds", (Object)this.agentPauseDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ConnectedToAgentTimestamp": {
                return Optional.ofNullable(clazz.cast(this.connectedToAgentTimestamp()));
            }
            case "AgentPauseDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.agentPauseDurationInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentInfo, T> g) {
        return obj -> g.apply((AgentInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Instant connectedToAgentTimestamp;
        private Integer agentPauseDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentInfo model) {
            this.id(model.id);
            this.connectedToAgentTimestamp(model.connectedToAgentTimestamp);
            this.agentPauseDurationInSeconds(model.agentPauseDurationInSeconds);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getConnectedToAgentTimestamp() {
            return this.connectedToAgentTimestamp;
        }

        public final void setConnectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
        }

        @Override
        public final Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
            return this;
        }

        public final Integer getAgentPauseDurationInSeconds() {
            return this.agentPauseDurationInSeconds;
        }

        public final void setAgentPauseDurationInSeconds(Integer agentPauseDurationInSeconds) {
            this.agentPauseDurationInSeconds = agentPauseDurationInSeconds;
        }

        @Override
        public final Builder agentPauseDurationInSeconds(Integer agentPauseDurationInSeconds) {
            this.agentPauseDurationInSeconds = agentPauseDurationInSeconds;
            return this;
        }

        public AgentInfo build() {
            return new AgentInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentInfo> {
        public Builder id(String var1);

        public Builder connectedToAgentTimestamp(Instant var1);

        public Builder agentPauseDurationInSeconds(Integer var1);
    }
}

