/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.SecurityProfileIdsCopier;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.services.connect.model.UserIdentityInfo;
import software.amazon.awssdk.services.connect.model.UserPhoneConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(User.getter(User::id)).setter(User.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(User.getter(User::arn)).setter(User.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(User.getter(User::username)).setter(User.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<UserIdentityInfo> IDENTITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityInfo").getter(User.getter(User::identityInfo)).setter(User.setter(Builder::identityInfo)).constructor(UserIdentityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityInfo").build()}).build();
    private static final SdkField<UserPhoneConfig> PHONE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PhoneConfig").getter(User.getter(User::phoneConfig)).setter(User.setter(Builder::phoneConfig)).constructor(UserPhoneConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneConfig").build()}).build();
    private static final SdkField<String> DIRECTORY_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryUserId").getter(User.getter(User::directoryUserId)).setter(User.setter(Builder::directoryUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryUserId").build()}).build();
    private static final SdkField<List<String>> SECURITY_PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityProfileIds").getter(User.getter(User::securityProfileIds)).setter(User.setter(Builder::securityProfileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(User.getter(User::routingProfileId)).setter(User.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<String> HIERARCHY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HierarchyGroupId").getter(User.getter(User::hierarchyGroupId)).setter(User.setter(Builder::hierarchyGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(User.getter(User::tags)).setter(User.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(User.getter(User::lastModifiedTime)).setter(User.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(User.getter(User::lastModifiedRegion)).setter(User.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, USERNAME_FIELD, IDENTITY_INFO_FIELD, PHONE_CONFIG_FIELD, DIRECTORY_USER_ID_FIELD, SECURITY_PROFILE_IDS_FIELD, ROUTING_PROFILE_ID_FIELD, HIERARCHY_GROUP_ID_FIELD, TAGS_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String username;
    private final UserIdentityInfo identityInfo;
    private final UserPhoneConfig phoneConfig;
    private final String directoryUserId;
    private final List<String> securityProfileIds;
    private final String routingProfileId;
    private final String hierarchyGroupId;
    private final Map<String, String> tags;
    private final Instant lastModifiedTime;
    private final String lastModifiedRegion;

    private User(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.username = builder.username;
        this.identityInfo = builder.identityInfo;
        this.phoneConfig = builder.phoneConfig;
        this.directoryUserId = builder.directoryUserId;
        this.securityProfileIds = builder.securityProfileIds;
        this.routingProfileId = builder.routingProfileId;
        this.hierarchyGroupId = builder.hierarchyGroupId;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String username() {
        return this.username;
    }

    public final UserIdentityInfo identityInfo() {
        return this.identityInfo;
    }

    public final UserPhoneConfig phoneConfig() {
        return this.phoneConfig;
    }

    public final String directoryUserId() {
        return this.directoryUserId;
    }

    public final boolean hasSecurityProfileIds() {
        return this.securityProfileIds != null && !(this.securityProfileIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityProfileIds() {
        return this.securityProfileIds;
    }

    public final String routingProfileId() {
        return this.routingProfileId;
    }

    public final String hierarchyGroupId() {
        return this.hierarchyGroupId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityProfileIds() ? this.securityProfileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.username(), other.username()) && Objects.equals(this.identityInfo(), other.identityInfo()) && Objects.equals(this.phoneConfig(), other.phoneConfig()) && Objects.equals(this.directoryUserId(), other.directoryUserId()) && this.hasSecurityProfileIds() == other.hasSecurityProfileIds() && Objects.equals(this.securityProfileIds(), other.securityProfileIds()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && Objects.equals(this.hierarchyGroupId(), other.hierarchyGroupId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion());
    }

    public final String toString() {
        return ToString.builder((String)"User").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Username", (Object)this.username()).add("IdentityInfo", (Object)this.identityInfo()).add("PhoneConfig", (Object)this.phoneConfig()).add("DirectoryUserId", (Object)this.directoryUserId()).add("SecurityProfileIds", this.hasSecurityProfileIds() ? this.securityProfileIds() : null).add("RoutingProfileId", (Object)this.routingProfileId()).add("HierarchyGroupId", (Object)this.hierarchyGroupId()).add("Tags", this.hasTags() ? this.tags() : null).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "IdentityInfo": {
                return Optional.ofNullable(clazz.cast(this.identityInfo()));
            }
            case "PhoneConfig": {
                return Optional.ofNullable(clazz.cast(this.phoneConfig()));
            }
            case "DirectoryUserId": {
                return Optional.ofNullable(clazz.cast(this.directoryUserId()));
            }
            case "SecurityProfileIds": {
                return Optional.ofNullable(clazz.cast(this.securityProfileIds()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "HierarchyGroupId": {
                return Optional.ofNullable(clazz.cast(this.hierarchyGroupId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String username;
        private UserIdentityInfo identityInfo;
        private UserPhoneConfig phoneConfig;
        private String directoryUserId;
        private List<String> securityProfileIds = DefaultSdkAutoConstructList.getInstance();
        private String routingProfileId;
        private String hierarchyGroupId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant lastModifiedTime;
        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.id(model.id);
            this.arn(model.arn);
            this.username(model.username);
            this.identityInfo(model.identityInfo);
            this.phoneConfig(model.phoneConfig);
            this.directoryUserId(model.directoryUserId);
            this.securityProfileIds(model.securityProfileIds);
            this.routingProfileId(model.routingProfileId);
            this.hierarchyGroupId(model.hierarchyGroupId);
            this.tags(model.tags);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final UserIdentityInfo.Builder getIdentityInfo() {
            return this.identityInfo != null ? this.identityInfo.toBuilder() : null;
        }

        public final void setIdentityInfo(UserIdentityInfo.BuilderImpl identityInfo) {
            this.identityInfo = identityInfo != null ? identityInfo.build() : null;
        }

        @Override
        public final Builder identityInfo(UserIdentityInfo identityInfo) {
            this.identityInfo = identityInfo;
            return this;
        }

        public final UserPhoneConfig.Builder getPhoneConfig() {
            return this.phoneConfig != null ? this.phoneConfig.toBuilder() : null;
        }

        public final void setPhoneConfig(UserPhoneConfig.BuilderImpl phoneConfig) {
            this.phoneConfig = phoneConfig != null ? phoneConfig.build() : null;
        }

        @Override
        public final Builder phoneConfig(UserPhoneConfig phoneConfig) {
            this.phoneConfig = phoneConfig;
            return this;
        }

        public final String getDirectoryUserId() {
            return this.directoryUserId;
        }

        public final void setDirectoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
        }

        @Override
        public final Builder directoryUserId(String directoryUserId) {
            this.directoryUserId = directoryUserId;
            return this;
        }

        public final Collection<String> getSecurityProfileIds() {
            if (this.securityProfileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityProfileIds;
        }

        public final void setSecurityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
        }

        @Override
        public final Builder securityProfileIds(Collection<String> securityProfileIds) {
            this.securityProfileIds = SecurityProfileIdsCopier.copy(securityProfileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityProfileIds(String ... securityProfileIds) {
            this.securityProfileIds(Arrays.asList(securityProfileIds));
            return this;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final String getHierarchyGroupId() {
            return this.hierarchyGroupId;
        }

        public final void setHierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
        }

        @Override
        public final Builder hierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder username(String var1);

        public Builder identityInfo(UserIdentityInfo var1);

        default public Builder identityInfo(Consumer<UserIdentityInfo.Builder> identityInfo) {
            return this.identityInfo((UserIdentityInfo)((UserIdentityInfo.Builder)UserIdentityInfo.builder().applyMutation(identityInfo)).build());
        }

        public Builder phoneConfig(UserPhoneConfig var1);

        default public Builder phoneConfig(Consumer<UserPhoneConfig.Builder> phoneConfig) {
            return this.phoneConfig((UserPhoneConfig)((UserPhoneConfig.Builder)UserPhoneConfig.builder().applyMutation(phoneConfig)).build());
        }

        public Builder directoryUserId(String var1);

        public Builder securityProfileIds(Collection<String> var1);

        public Builder securityProfileIds(String ... var1);

        public Builder routingProfileId(String var1);

        public Builder hierarchyGroupId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedRegion(String var1);
    }
}

