/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceStorageResourceType {
    CHAT_TRANSCRIPTS("CHAT_TRANSCRIPTS"),
    CALL_RECORDINGS("CALL_RECORDINGS"),
    SCHEDULED_REPORTS("SCHEDULED_REPORTS"),
    MEDIA_STREAMS("MEDIA_STREAMS"),
    CONTACT_TRACE_RECORDS("CONTACT_TRACE_RECORDS"),
    AGENT_EVENTS("AGENT_EVENTS"),
    REAL_TIME_CONTACT_ANALYSIS_SEGMENTS("REAL_TIME_CONTACT_ANALYSIS_SEGMENTS"),
    ATTACHMENTS("ATTACHMENTS"),
    CONTACT_EVALUATIONS("CONTACT_EVALUATIONS"),
    SCREEN_RECORDINGS("SCREEN_RECORDINGS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceStorageResourceType> VALUE_MAP;
    private final String value;

    private InstanceStorageResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceStorageResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceStorageResourceType> knownValues() {
        EnumSet<InstanceStorageResourceType> knownValues = EnumSet.allOf(InstanceStorageResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceStorageResourceType.class, InstanceStorageResourceType::toString);
    }
}

