/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.Application;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsRequest;
import software.amazon.awssdk.services.connect.model.ListSecurityProfileApplicationsResponse;

public class ListSecurityProfileApplicationsPublisher
implements SdkPublisher<ListSecurityProfileApplicationsResponse> {
    private final ConnectAsyncClient client;
    private final ListSecurityProfileApplicationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityProfileApplicationsPublisher(ConnectAsyncClient client, ListSecurityProfileApplicationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityProfileApplicationsPublisher(ConnectAsyncClient client, ListSecurityProfileApplicationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityProfileApplicationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityProfileApplicationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Application> applications() {
        Function<ListSecurityProfileApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applications() != null) {
                return response.applications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSecurityProfileApplicationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSecurityProfileApplicationsResponseFetcher
    implements AsyncPageFetcher<ListSecurityProfileApplicationsResponse> {
        private ListSecurityProfileApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfileApplicationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityProfileApplicationsResponse> nextPage(ListSecurityProfileApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfileApplicationsPublisher.this.client.listSecurityProfileApplications(ListSecurityProfileApplicationsPublisher.this.firstRequest);
            }
            return ListSecurityProfileApplicationsPublisher.this.client.listSecurityProfileApplications((ListSecurityProfileApplicationsRequest)((Object)ListSecurityProfileApplicationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

