/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DirectoryType {
    SAML("SAML"),
    CONNECT_MANAGED("CONNECT_MANAGED"),
    EXISTING_DIRECTORY("EXISTING_DIRECTORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DirectoryType> VALUE_MAP;
    private final String value;

    private DirectoryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DirectoryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DirectoryType> knownValues() {
        EnumSet<DirectoryType> knownValues = EnumSet.allOf(DirectoryType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DirectoryType.class, DirectoryType::toString);
    }
}

