/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.AgentStatusSummary;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesRequest;
import software.amazon.awssdk.services.connect.model.ListAgentStatusesResponse;

public class ListAgentStatusesPublisher
implements SdkPublisher<ListAgentStatusesResponse> {
    private final ConnectAsyncClient client;
    private final ListAgentStatusesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAgentStatusesPublisher(ConnectAsyncClient client, ListAgentStatusesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAgentStatusesPublisher(ConnectAsyncClient client, ListAgentStatusesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAgentStatusesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAgentStatusesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AgentStatusSummary> agentStatusSummaryList() {
        Function<ListAgentStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.agentStatusSummaryList() != null) {
                return response.agentStatusSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAgentStatusesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAgentStatusesResponseFetcher
    implements AsyncPageFetcher<ListAgentStatusesResponse> {
        private ListAgentStatusesResponseFetcher() {
        }

        public boolean hasNextPage(ListAgentStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAgentStatusesResponse> nextPage(ListAgentStatusesResponse previousPage) {
            if (previousPage == null) {
                return ListAgentStatusesPublisher.this.client.listAgentStatuses(ListAgentStatusesPublisher.this.firstRequest);
            }
            return ListAgentStatusesPublisher.this.client.listAgentStatuses((ListAgentStatusesRequest)((Object)ListAgentStatusesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

