/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsRequest;
import software.amazon.awssdk.services.connect.model.SearchResourceTagsResponse;
import software.amazon.awssdk.services.connect.model.TagSet;

public class SearchResourceTagsIterable
implements SdkIterable<SearchResourceTagsResponse> {
    private final ConnectClient client;
    private final SearchResourceTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchResourceTagsIterable(ConnectClient client, SearchResourceTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchResourceTagsResponseFetcher();
    }

    public Iterator<SearchResourceTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TagSet> tags() {
        Function<SearchResourceTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchResourceTagsResponseFetcher
    implements SyncPageFetcher<SearchResourceTagsResponse> {
        private SearchResourceTagsResponseFetcher() {
        }

        public boolean hasNextPage(SearchResourceTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchResourceTagsResponse nextPage(SearchResourceTagsResponse previousPage) {
            if (previousPage == null) {
                return SearchResourceTagsIterable.this.client.searchResourceTags(SearchResourceTagsIterable.this.firstRequest);
            }
            return SearchResourceTagsIterable.this.client.searchResourceTags((SearchResourceTagsRequest)((Object)SearchResourceTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

