/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListTrafficDistributionGroupsResponse;
import software.amazon.awssdk.services.connect.model.TrafficDistributionGroupSummary;

public class ListTrafficDistributionGroupsIterable
implements SdkIterable<ListTrafficDistributionGroupsResponse> {
    private final ConnectClient client;
    private final ListTrafficDistributionGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrafficDistributionGroupsIterable(ConnectClient client, ListTrafficDistributionGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTrafficDistributionGroupsResponseFetcher();
    }

    public Iterator<ListTrafficDistributionGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrafficDistributionGroupSummary> trafficDistributionGroupSummaryList() {
        Function<ListTrafficDistributionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trafficDistributionGroupSummaryList() != null) {
                return response.trafficDistributionGroupSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrafficDistributionGroupsResponseFetcher
    implements SyncPageFetcher<ListTrafficDistributionGroupsResponse> {
        private ListTrafficDistributionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrafficDistributionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrafficDistributionGroupsResponse nextPage(ListTrafficDistributionGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListTrafficDistributionGroupsIterable.this.client.listTrafficDistributionGroups(ListTrafficDistributionGroupsIterable.this.firstRequest);
            }
            return ListTrafficDistributionGroupsIterable.this.client.listTrafficDistributionGroups((ListTrafficDistributionGroupsRequest)((Object)ListTrafficDistributionGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

