/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesRequest;
import software.amazon.awssdk.services.connect.model.ListTaskTemplatesResponse;
import software.amazon.awssdk.services.connect.model.TaskTemplateMetadata;

public class ListTaskTemplatesIterable
implements SdkIterable<ListTaskTemplatesResponse> {
    private final ConnectClient client;
    private final ListTaskTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTaskTemplatesIterable(ConnectClient client, ListTaskTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTaskTemplatesResponseFetcher();
    }

    public Iterator<ListTaskTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TaskTemplateMetadata> taskTemplates() {
        Function<ListTaskTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskTemplates() != null) {
                return response.taskTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTaskTemplatesResponseFetcher
    implements SyncPageFetcher<ListTaskTemplatesResponse> {
        private ListTaskTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTaskTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTaskTemplatesResponse nextPage(ListTaskTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListTaskTemplatesIterable.this.client.listTaskTemplates(ListTaskTemplatesIterable.this.firstRequest);
            }
            return ListTaskTemplatesIterable.this.client.listTaskTemplates((ListTaskTemplatesRequest)((Object)ListTaskTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

