/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateContactFlowResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, CreateContactFlowResponse> {
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(CreateContactFlowResponse.getter(CreateContactFlowResponse::contactFlowId)).setter(CreateContactFlowResponse.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowArn").getter(CreateContactFlowResponse.getter(CreateContactFlowResponse::contactFlowArn)).setter(CreateContactFlowResponse.setter(Builder::contactFlowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOW_ID_FIELD, CONTACT_FLOW_ARN_FIELD));
    private final String contactFlowId;
    private final String contactFlowArn;

    private CreateContactFlowResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlowId = builder.contactFlowId;
        this.contactFlowArn = builder.contactFlowArn;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final String contactFlowArn() {
        return this.contactFlowArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContactFlowResponse)) {
            return false;
        }
        CreateContactFlowResponse other = (CreateContactFlowResponse)((Object)obj);
        return Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.contactFlowArn(), other.contactFlowArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateContactFlowResponse").add("ContactFlowId", (Object)this.contactFlowId()).add("ContactFlowArn", (Object)this.contactFlowArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "ContactFlowArn": {
                return Optional.ofNullable(clazz.cast(this.contactFlowArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateContactFlowResponse, T> g) {
        return obj -> g.apply((CreateContactFlowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String contactFlowId;
        private String contactFlowArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContactFlowResponse model) {
            super(model);
            this.contactFlowId(model.contactFlowId);
            this.contactFlowArn(model.contactFlowArn);
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getContactFlowArn() {
            return this.contactFlowArn;
        }

        public final void setContactFlowArn(String contactFlowArn) {
            this.contactFlowArn = contactFlowArn;
        }

        @Override
        public final Builder contactFlowArn(String contactFlowArn) {
            this.contactFlowArn = contactFlowArn;
            return this;
        }

        @Override
        public CreateContactFlowResponse build() {
            return new CreateContactFlowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateContactFlowResponse> {
        public Builder contactFlowId(String var1);

        public Builder contactFlowArn(String var1);
    }
}

