/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.ListUseCasesRequest;
import software.amazon.awssdk.services.connect.model.ListUseCasesResponse;
import software.amazon.awssdk.services.connect.model.UseCase;

public class ListUseCasesIterable
implements SdkIterable<ListUseCasesResponse> {
    private final ConnectClient client;
    private final ListUseCasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUseCasesIterable(ConnectClient client, ListUseCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUseCasesResponseFetcher();
    }

    public Iterator<ListUseCasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<UseCase> useCaseSummaryList() {
        Function<ListUseCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.useCaseSummaryList() != null) {
                return response.useCaseSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListUseCasesResponseFetcher
    implements SyncPageFetcher<ListUseCasesResponse> {
        private ListUseCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListUseCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUseCasesResponse nextPage(ListUseCasesResponse previousPage) {
            if (previousPage == null) {
                return ListUseCasesIterable.this.client.listUseCases(ListUseCasesIterable.this.firstRequest);
            }
            return ListUseCasesIterable.this.client.listUseCases((ListUseCasesRequest)((Object)ListUseCasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

