/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.AvailableNumberSummary;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse;

public class SearchAvailablePhoneNumbersIterable
implements SdkIterable<SearchAvailablePhoneNumbersResponse> {
    private final ConnectClient client;
    private final SearchAvailablePhoneNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchAvailablePhoneNumbersIterable(ConnectClient client, SearchAvailablePhoneNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchAvailablePhoneNumbersResponseFetcher();
    }

    public Iterator<SearchAvailablePhoneNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AvailableNumberSummary> availableNumbersList() {
        Function<SearchAvailablePhoneNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.availableNumbersList() != null) {
                return response.availableNumbersList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchAvailablePhoneNumbersResponseFetcher
    implements SyncPageFetcher<SearchAvailablePhoneNumbersResponse> {
        private SearchAvailablePhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(SearchAvailablePhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchAvailablePhoneNumbersResponse nextPage(SearchAvailablePhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return SearchAvailablePhoneNumbersIterable.this.client.searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersIterable.this.firstRequest);
            }
            return SearchAvailablePhoneNumbersIterable.this.client.searchAvailablePhoneNumbers((SearchAvailablePhoneNumbersRequest)((Object)SearchAvailablePhoneNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

