/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.model.RoutingProfile;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesRequest;
import software.amazon.awssdk.services.connect.model.SearchRoutingProfilesResponse;

public class SearchRoutingProfilesIterable
implements SdkIterable<SearchRoutingProfilesResponse> {
    private final ConnectClient client;
    private final SearchRoutingProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchRoutingProfilesIterable(ConnectClient client, SearchRoutingProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchRoutingProfilesResponseFetcher();
    }

    public Iterator<SearchRoutingProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RoutingProfile> routingProfiles() {
        Function<SearchRoutingProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingProfiles() != null) {
                return response.routingProfiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchRoutingProfilesResponseFetcher
    implements SyncPageFetcher<SearchRoutingProfilesResponse> {
        private SearchRoutingProfilesResponseFetcher() {
        }

        public boolean hasNextPage(SearchRoutingProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchRoutingProfilesResponse nextPage(SearchRoutingProfilesResponse previousPage) {
            if (previousPage == null) {
                return SearchRoutingProfilesIterable.this.client.searchRoutingProfiles(SearchRoutingProfilesIterable.this.firstRequest);
            }
            return SearchRoutingProfilesIterable.this.client.searchRoutingProfiles((SearchRoutingProfilesRequest)((Object)SearchRoutingProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

