/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Request;
import software.amazon.awssdk.services.connect.model.GetMetricDataV2Response;

public class GetMetricDataV2Publisher
implements SdkPublisher<GetMetricDataV2Response> {
    private final ConnectAsyncClient client;
    private final GetMetricDataV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetMetricDataV2Publisher(ConnectAsyncClient client, GetMetricDataV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private GetMetricDataV2Publisher(ConnectAsyncClient client, GetMetricDataV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetMetricDataV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetMetricDataV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetMetricDataV2ResponseFetcher
    implements AsyncPageFetcher<GetMetricDataV2Response> {
        private GetMetricDataV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetMetricDataV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetMetricDataV2Response> nextPage(GetMetricDataV2Response previousPage) {
            if (previousPage == null) {
                return GetMetricDataV2Publisher.this.client.getMetricDataV2(GetMetricDataV2Publisher.this.firstRequest);
            }
            return GetMetricDataV2Publisher.this.client.getMetricDataV2((GetMetricDataV2Request)((Object)GetMetricDataV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

