/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.HierarchyPath;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HierarchyGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HierarchyGroup> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(HierarchyGroup.getter(HierarchyGroup::id)).setter(HierarchyGroup.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(HierarchyGroup.getter(HierarchyGroup::arn)).setter(HierarchyGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(HierarchyGroup.getter(HierarchyGroup::name)).setter(HierarchyGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> LEVEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LevelId").getter(HierarchyGroup.getter(HierarchyGroup::levelId)).setter(HierarchyGroup.setter(Builder::levelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelId").build()}).build();
    private static final SdkField<HierarchyPath> HIERARCHY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HierarchyPath").getter(HierarchyGroup.getter(HierarchyGroup::hierarchyPath)).setter(HierarchyGroup.setter(Builder::hierarchyPath)).constructor(HierarchyPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyPath").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(HierarchyGroup.getter(HierarchyGroup::tags)).setter(HierarchyGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, NAME_FIELD, LEVEL_ID_FIELD, HIERARCHY_PATH_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String name;
    private final String levelId;
    private final HierarchyPath hierarchyPath;
    private final Map<String, String> tags;

    private HierarchyGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.levelId = builder.levelId;
        this.hierarchyPath = builder.hierarchyPath;
        this.tags = builder.tags;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String levelId() {
        return this.levelId;
    }

    public final HierarchyPath hierarchyPath() {
        return this.hierarchyPath;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hierarchyPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyGroup)) {
            return false;
        }
        HierarchyGroup other = (HierarchyGroup)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.levelId(), other.levelId()) && Objects.equals(this.hierarchyPath(), other.hierarchyPath()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"HierarchyGroup").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("LevelId", (Object)this.levelId()).add("HierarchyPath", (Object)this.hierarchyPath()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "LevelId": {
                return Optional.ofNullable(clazz.cast(this.levelId()));
            }
            case "HierarchyPath": {
                return Optional.ofNullable(clazz.cast(this.hierarchyPath()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HierarchyGroup, T> g) {
        return obj -> g.apply((HierarchyGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String name;
        private String levelId;
        private HierarchyPath hierarchyPath;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchyGroup model) {
            this.id(model.id);
            this.arn(model.arn);
            this.name(model.name);
            this.levelId(model.levelId);
            this.hierarchyPath(model.hierarchyPath);
            this.tags(model.tags);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLevelId() {
            return this.levelId;
        }

        public final void setLevelId(String levelId) {
            this.levelId = levelId;
        }

        @Override
        public final Builder levelId(String levelId) {
            this.levelId = levelId;
            return this;
        }

        public final HierarchyPath.Builder getHierarchyPath() {
            return this.hierarchyPath != null ? this.hierarchyPath.toBuilder() : null;
        }

        public final void setHierarchyPath(HierarchyPath.BuilderImpl hierarchyPath) {
            this.hierarchyPath = hierarchyPath != null ? hierarchyPath.build() : null;
        }

        @Override
        public final Builder hierarchyPath(HierarchyPath hierarchyPath) {
            this.hierarchyPath = hierarchyPath;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public HierarchyGroup build() {
            return new HierarchyGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HierarchyGroup> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder levelId(String var1);

        public Builder hierarchyPath(HierarchyPath var1);

        default public Builder hierarchyPath(Consumer<HierarchyPath.Builder> hierarchyPath) {
            return this.hierarchyPath((HierarchyPath)((HierarchyPath.Builder)HierarchyPath.builder().applyMutation(hierarchyPath)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

