/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueueType {
    STANDARD("STANDARD"),
    AGENT("AGENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueueType> VALUE_MAP;
    private final String value;

    private QueueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueueType> knownValues() {
        EnumSet<QueueType> knownValues = EnumSet.allOf(QueueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueueType.class, QueueType::toString);
    }
}

