/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.ConnectAsyncClientBuilder;
import software.amazon.awssdk.services.connect.ConnectServiceClientConfiguration;
import software.amazon.awssdk.services.connect.DefaultConnectAsyncClient;
import software.amazon.awssdk.services.connect.DefaultConnectBaseClientBuilder;
import software.amazon.awssdk.services.connect.endpoints.ConnectEndpointProvider;

@SdkInternalApi
final class DefaultConnectAsyncClientBuilder
extends DefaultConnectBaseClientBuilder<ConnectAsyncClientBuilder, ConnectAsyncClient>
implements ConnectAsyncClientBuilder {
    DefaultConnectAsyncClientBuilder() {
    }

    @Override
    public DefaultConnectAsyncClientBuilder endpointProvider(ConnectEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ConnectAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultConnectAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ConnectServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultConnectAsyncClient client = new DefaultConnectAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ConnectServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ConnectServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

