/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.UseCaseType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UseCase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UseCase> {
    private static final SdkField<String> USE_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseCaseId").getter(UseCase.getter(UseCase::useCaseId)).setter(UseCase.setter(Builder::useCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseId").build()}).build();
    private static final SdkField<String> USE_CASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseCaseArn").getter(UseCase.getter(UseCase::useCaseArn)).setter(UseCase.setter(Builder::useCaseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseArn").build()}).build();
    private static final SdkField<String> USE_CASE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseCaseType").getter(UseCase.getter(UseCase::useCaseTypeAsString)).setter(UseCase.setter(Builder::useCaseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_CASE_ID_FIELD, USE_CASE_ARN_FIELD, USE_CASE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String useCaseId;
    private final String useCaseArn;
    private final String useCaseType;

    private UseCase(BuilderImpl builder) {
        this.useCaseId = builder.useCaseId;
        this.useCaseArn = builder.useCaseArn;
        this.useCaseType = builder.useCaseType;
    }

    public final String useCaseId() {
        return this.useCaseId;
    }

    public final String useCaseArn() {
        return this.useCaseArn;
    }

    public final UseCaseType useCaseType() {
        return UseCaseType.fromValue(this.useCaseType);
    }

    public final String useCaseTypeAsString() {
        return this.useCaseType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.useCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCaseTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UseCase)) {
            return false;
        }
        UseCase other = (UseCase)obj;
        return Objects.equals(this.useCaseId(), other.useCaseId()) && Objects.equals(this.useCaseArn(), other.useCaseArn()) && Objects.equals(this.useCaseTypeAsString(), other.useCaseTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UseCase").add("UseCaseId", (Object)this.useCaseId()).add("UseCaseArn", (Object)this.useCaseArn()).add("UseCaseType", (Object)this.useCaseTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UseCaseId": {
                return Optional.ofNullable(clazz.cast(this.useCaseId()));
            }
            case "UseCaseArn": {
                return Optional.ofNullable(clazz.cast(this.useCaseArn()));
            }
            case "UseCaseType": {
                return Optional.ofNullable(clazz.cast(this.useCaseTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UseCase, T> g) {
        return obj -> g.apply((UseCase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String useCaseId;
        private String useCaseArn;
        private String useCaseType;

        private BuilderImpl() {
        }

        private BuilderImpl(UseCase model) {
            this.useCaseId(model.useCaseId);
            this.useCaseArn(model.useCaseArn);
            this.useCaseType(model.useCaseType);
        }

        public final String getUseCaseId() {
            return this.useCaseId;
        }

        public final void setUseCaseId(String useCaseId) {
            this.useCaseId = useCaseId;
        }

        @Override
        public final Builder useCaseId(String useCaseId) {
            this.useCaseId = useCaseId;
            return this;
        }

        public final String getUseCaseArn() {
            return this.useCaseArn;
        }

        public final void setUseCaseArn(String useCaseArn) {
            this.useCaseArn = useCaseArn;
        }

        @Override
        public final Builder useCaseArn(String useCaseArn) {
            this.useCaseArn = useCaseArn;
            return this;
        }

        public final String getUseCaseType() {
            return this.useCaseType;
        }

        public final void setUseCaseType(String useCaseType) {
            this.useCaseType = useCaseType;
        }

        @Override
        public final Builder useCaseType(String useCaseType) {
            this.useCaseType = useCaseType;
            return this;
        }

        @Override
        public final Builder useCaseType(UseCaseType useCaseType) {
            this.useCaseType(useCaseType == null ? null : useCaseType.toString());
            return this;
        }

        public UseCase build() {
            return new UseCase(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UseCase> {
        public Builder useCaseId(String var1);

        public Builder useCaseArn(String var1);

        public Builder useCaseType(String var1);

        public Builder useCaseType(UseCaseType var1);
    }
}

