/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactInitiationMethod {
    INBOUND("INBOUND"),
    OUTBOUND("OUTBOUND"),
    TRANSFER("TRANSFER"),
    QUEUE_TRANSFER("QUEUE_TRANSFER"),
    CALLBACK("CALLBACK"),
    API("API"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactInitiationMethod> VALUE_MAP;
    private final String value;

    private ContactInitiationMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactInitiationMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactInitiationMethod> knownValues() {
        EnumSet<ContactInitiationMethod> knownValues = EnumSet.allOf(ContactInitiationMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactInitiationMethod.class, ContactInitiationMethod::toString);
    }
}

