/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.AvailableNumberSummary;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.SearchAvailablePhoneNumbersResponse;

public class SearchAvailablePhoneNumbersPublisher
implements SdkPublisher<SearchAvailablePhoneNumbersResponse> {
    private final ConnectAsyncClient client;
    private final SearchAvailablePhoneNumbersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchAvailablePhoneNumbersPublisher(ConnectAsyncClient client, SearchAvailablePhoneNumbersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchAvailablePhoneNumbersPublisher(ConnectAsyncClient client, SearchAvailablePhoneNumbersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchAvailablePhoneNumbersResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchAvailablePhoneNumbersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AvailableNumberSummary> availableNumbersList() {
        Function<SearchAvailablePhoneNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.availableNumbersList() != null) {
                return response.availableNumbersList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchAvailablePhoneNumbersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchAvailablePhoneNumbersResponseFetcher
    implements AsyncPageFetcher<SearchAvailablePhoneNumbersResponse> {
        private SearchAvailablePhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(SearchAvailablePhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchAvailablePhoneNumbersResponse> nextPage(SearchAvailablePhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return SearchAvailablePhoneNumbersPublisher.this.client.searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersPublisher.this.firstRequest);
            }
            return SearchAvailablePhoneNumbersPublisher.this.client.searchAvailablePhoneNumbers((SearchAvailablePhoneNumbersRequest)((Object)SearchAvailablePhoneNumbersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

