/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PhoneType {
    SOFT_PHONE("SOFT_PHONE"),
    DESK_PHONE("DESK_PHONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PhoneType> VALUE_MAP;
    private final String value;

    private PhoneType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PhoneType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PhoneType> knownValues() {
        EnumSet<PhoneType> knownValues = EnumSet.allOf(PhoneType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PhoneType.class, PhoneType::toString);
    }
}

