/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersSummary;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Request;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersV2Response;

public class ListPhoneNumbersV2Publisher
implements SdkPublisher<ListPhoneNumbersV2Response> {
    private final ConnectAsyncClient client;
    private final ListPhoneNumbersV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPhoneNumbersV2Publisher(ConnectAsyncClient client, ListPhoneNumbersV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPhoneNumbersV2Publisher(ConnectAsyncClient client, ListPhoneNumbersV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPhoneNumbersV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPhoneNumbersV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListPhoneNumbersSummary> listPhoneNumbersSummaryList() {
        Function<ListPhoneNumbersV2Response, Iterator> getIterator = response -> {
            if (response != null && response.listPhoneNumbersSummaryList() != null) {
                return response.listPhoneNumbersSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPhoneNumbersV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPhoneNumbersV2ResponseFetcher
    implements AsyncPageFetcher<ListPhoneNumbersV2Response> {
        private ListPhoneNumbersV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumbersV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPhoneNumbersV2Response> nextPage(ListPhoneNumbersV2Response previousPage) {
            if (previousPage == null) {
                return ListPhoneNumbersV2Publisher.this.client.listPhoneNumbersV2(ListPhoneNumbersV2Publisher.this.firstRequest);
            }
            return ListPhoneNumbersV2Publisher.this.client.listPhoneNumbersV2((ListPhoneNumbersV2Request)((Object)ListPhoneNumbersV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

