/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.MediaConcurrenciesCopier;
import software.amazon.awssdk.services.connect.model.MediaConcurrency;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoutingProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoutingProfile> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(RoutingProfile.getter(RoutingProfile::instanceId)).setter(RoutingProfile.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RoutingProfile.getter(RoutingProfile::name)).setter(RoutingProfile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileArn").getter(RoutingProfile.getter(RoutingProfile::routingProfileArn)).setter(RoutingProfile.setter(Builder::routingProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileArn").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(RoutingProfile.getter(RoutingProfile::routingProfileId)).setter(RoutingProfile.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RoutingProfile.getter(RoutingProfile::description)).setter(RoutingProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<MediaConcurrency>> MEDIA_CONCURRENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaConcurrencies").getter(RoutingProfile.getter(RoutingProfile::mediaConcurrencies)).setter(RoutingProfile.setter(Builder::mediaConcurrencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaConcurrencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaConcurrency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_OUTBOUND_QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultOutboundQueueId").getter(RoutingProfile.getter(RoutingProfile::defaultOutboundQueueId)).setter(RoutingProfile.setter(Builder::defaultOutboundQueueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOutboundQueueId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RoutingProfile.getter(RoutingProfile::tags)).setter(RoutingProfile.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NAME_FIELD, ROUTING_PROFILE_ARN_FIELD, ROUTING_PROFILE_ID_FIELD, DESCRIPTION_FIELD, MEDIA_CONCURRENCIES_FIELD, DEFAULT_OUTBOUND_QUEUE_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String name;
    private final String routingProfileArn;
    private final String routingProfileId;
    private final String description;
    private final List<MediaConcurrency> mediaConcurrencies;
    private final String defaultOutboundQueueId;
    private final Map<String, String> tags;

    private RoutingProfile(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.name = builder.name;
        this.routingProfileArn = builder.routingProfileArn;
        this.routingProfileId = builder.routingProfileId;
        this.description = builder.description;
        this.mediaConcurrencies = builder.mediaConcurrencies;
        this.defaultOutboundQueueId = builder.defaultOutboundQueueId;
        this.tags = builder.tags;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String name() {
        return this.name;
    }

    public final String routingProfileArn() {
        return this.routingProfileArn;
    }

    public final String routingProfileId() {
        return this.routingProfileId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMediaConcurrencies() {
        return this.mediaConcurrencies != null && !(this.mediaConcurrencies instanceof SdkAutoConstructList);
    }

    public final List<MediaConcurrency> mediaConcurrencies() {
        return this.mediaConcurrencies;
    }

    public final String defaultOutboundQueueId() {
        return this.defaultOutboundQueueId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaConcurrencies() ? this.mediaConcurrencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultOutboundQueueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingProfile)) {
            return false;
        }
        RoutingProfile other = (RoutingProfile)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.routingProfileArn(), other.routingProfileArn()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && Objects.equals(this.description(), other.description()) && this.hasMediaConcurrencies() == other.hasMediaConcurrencies() && Objects.equals(this.mediaConcurrencies(), other.mediaConcurrencies()) && Objects.equals(this.defaultOutboundQueueId(), other.defaultOutboundQueueId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RoutingProfile").add("InstanceId", (Object)this.instanceId()).add("Name", (Object)this.name()).add("RoutingProfileArn", (Object)this.routingProfileArn()).add("RoutingProfileId", (Object)this.routingProfileId()).add("Description", (Object)this.description()).add("MediaConcurrencies", this.hasMediaConcurrencies() ? this.mediaConcurrencies() : null).add("DefaultOutboundQueueId", (Object)this.defaultOutboundQueueId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RoutingProfileArn": {
                return Optional.ofNullable(clazz.cast(this.routingProfileArn()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MediaConcurrencies": {
                return Optional.ofNullable(clazz.cast(this.mediaConcurrencies()));
            }
            case "DefaultOutboundQueueId": {
                return Optional.ofNullable(clazz.cast(this.defaultOutboundQueueId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoutingProfile, T> g) {
        return obj -> g.apply((RoutingProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String name;
        private String routingProfileArn;
        private String routingProfileId;
        private String description;
        private List<MediaConcurrency> mediaConcurrencies = DefaultSdkAutoConstructList.getInstance();
        private String defaultOutboundQueueId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingProfile model) {
            this.instanceId(model.instanceId);
            this.name(model.name);
            this.routingProfileArn(model.routingProfileArn);
            this.routingProfileId(model.routingProfileId);
            this.description(model.description);
            this.mediaConcurrencies(model.mediaConcurrencies);
            this.defaultOutboundQueueId(model.defaultOutboundQueueId);
            this.tags(model.tags);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoutingProfileArn() {
            return this.routingProfileArn;
        }

        public final void setRoutingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
        }

        @Override
        @Transient
        public final Builder routingProfileArn(String routingProfileArn) {
            this.routingProfileArn = routingProfileArn;
            return this;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        @Override
        @Transient
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<MediaConcurrency.Builder> getMediaConcurrencies() {
            List<MediaConcurrency.Builder> result = MediaConcurrenciesCopier.copyToBuilder(this.mediaConcurrencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConcurrencies(Collection<MediaConcurrency.BuilderImpl> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copyFromBuilder(mediaConcurrencies);
        }

        @Override
        @Transient
        public final Builder mediaConcurrencies(Collection<MediaConcurrency> mediaConcurrencies) {
            this.mediaConcurrencies = MediaConcurrenciesCopier.copy(mediaConcurrencies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaConcurrencies(MediaConcurrency ... mediaConcurrencies) {
            this.mediaConcurrencies(Arrays.asList(mediaConcurrencies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder> ... mediaConcurrencies) {
            this.mediaConcurrencies(Stream.of(mediaConcurrencies).map(c -> (MediaConcurrency)((MediaConcurrency.Builder)MediaConcurrency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultOutboundQueueId() {
            return this.defaultOutboundQueueId;
        }

        public final void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
        }

        @Override
        @Transient
        public final Builder defaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public RoutingProfile build() {
            return new RoutingProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoutingProfile> {
        public Builder instanceId(String var1);

        public Builder name(String var1);

        public Builder routingProfileArn(String var1);

        public Builder routingProfileId(String var1);

        public Builder description(String var1);

        public Builder mediaConcurrencies(Collection<MediaConcurrency> var1);

        public Builder mediaConcurrencies(MediaConcurrency ... var1);

        public Builder mediaConcurrencies(Consumer<MediaConcurrency.Builder> ... var1);

        public Builder defaultOutboundQueueId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

