/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.PermissionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSecurityProfilePermissionsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListSecurityProfilePermissionsResponse> {
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(ListSecurityProfilePermissionsResponse.getter(ListSecurityProfilePermissionsResponse::permissions)).setter(ListSecurityProfilePermissionsResponse.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSecurityProfilePermissionsResponse.getter(ListSecurityProfilePermissionsResponse::nextToken)).setter(ListSecurityProfilePermissionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> permissions;
    private final String nextToken;

    private ListSecurityProfilePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.permissions = builder.permissions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissions() {
        return this.permissions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityProfilePermissionsResponse)) {
            return false;
        }
        ListSecurityProfilePermissionsResponse other = (ListSecurityProfilePermissionsResponse)((Object)obj);
        return this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSecurityProfilePermissionsResponse").add("Permissions", this.hasPermissions() ? this.permissions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityProfilePermissionsResponse, T> g) {
        return obj -> g.apply((ListSecurityProfilePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityProfilePermissionsResponse model) {
            super(model);
            this.permissions(model.permissions);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
        }

        @Override
        @Transient
        public final Builder permissions(Collection<String> permissions) {
            this.permissions = PermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(String ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSecurityProfilePermissionsResponse build() {
            return new ListSecurityProfilePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSecurityProfilePermissionsResponse> {
        public Builder permissions(Collection<String> var1);

        public Builder permissions(String ... var1);

        public Builder nextToken(String var1);
    }
}

