/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.HierarchyGroupSummary;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsRequest;
import software.amazon.awssdk.services.connect.model.ListUserHierarchyGroupsResponse;

public class ListUserHierarchyGroupsPublisher
implements SdkPublisher<ListUserHierarchyGroupsResponse> {
    private final ConnectAsyncClient client;
    private final ListUserHierarchyGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserHierarchyGroupsPublisher(ConnectAsyncClient client, ListUserHierarchyGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserHierarchyGroupsPublisher(ConnectAsyncClient client, ListUserHierarchyGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserHierarchyGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserHierarchyGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HierarchyGroupSummary> userHierarchyGroupSummaryList() {
        Function<ListUserHierarchyGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userHierarchyGroupSummaryList() != null) {
                return response.userHierarchyGroupSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUserHierarchyGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUserHierarchyGroupsResponseFetcher
    implements AsyncPageFetcher<ListUserHierarchyGroupsResponse> {
        private ListUserHierarchyGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserHierarchyGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserHierarchyGroupsResponse> nextPage(ListUserHierarchyGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListUserHierarchyGroupsPublisher.this.client.listUserHierarchyGroups(ListUserHierarchyGroupsPublisher.this.firstRequest);
            }
            return ListUserHierarchyGroupsPublisher.this.client.listUserHierarchyGroups((ListUserHierarchyGroupsRequest)((Object)ListUserHierarchyGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

