/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.LexBot;
import software.amazon.awssdk.services.connect.model.LexV2Bot;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateBotRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, AssociateBotRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(AssociateBotRequest.getter(AssociateBotRequest::instanceId)).setter(AssociateBotRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<LexBot> LEX_BOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LexBot").getter(AssociateBotRequest.getter(AssociateBotRequest::lexBot)).setter(AssociateBotRequest.setter(Builder::lexBot)).constructor(LexBot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBot").build()}).build();
    private static final SdkField<LexV2Bot> LEX_V2_BOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LexV2Bot").getter(AssociateBotRequest.getter(AssociateBotRequest::lexV2Bot)).setter(AssociateBotRequest.setter(Builder::lexV2Bot)).constructor(LexV2Bot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexV2Bot").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, LEX_BOT_FIELD, LEX_V2_BOT_FIELD));
    private final String instanceId;
    private final LexBot lexBot;
    private final LexV2Bot lexV2Bot;

    private AssociateBotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.lexBot = builder.lexBot;
        this.lexV2Bot = builder.lexV2Bot;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final LexBot lexBot() {
        return this.lexBot;
    }

    public final LexV2Bot lexV2Bot() {
        return this.lexV2Bot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexBot());
        hashCode = 31 * hashCode + Objects.hashCode(this.lexV2Bot());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateBotRequest)) {
            return false;
        }
        AssociateBotRequest other = (AssociateBotRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.lexBot(), other.lexBot()) && Objects.equals(this.lexV2Bot(), other.lexV2Bot());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateBotRequest").add("InstanceId", (Object)this.instanceId()).add("LexBot", (Object)this.lexBot()).add("LexV2Bot", (Object)this.lexV2Bot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "LexBot": {
                return Optional.ofNullable(clazz.cast(this.lexBot()));
            }
            case "LexV2Bot": {
                return Optional.ofNullable(clazz.cast(this.lexV2Bot()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateBotRequest, T> g) {
        return obj -> g.apply((AssociateBotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private LexBot lexBot;
        private LexV2Bot lexV2Bot;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateBotRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.lexBot(model.lexBot);
            this.lexV2Bot(model.lexV2Bot);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final LexBot.Builder getLexBot() {
            return this.lexBot != null ? this.lexBot.toBuilder() : null;
        }

        public final void setLexBot(LexBot.BuilderImpl lexBot) {
            this.lexBot = lexBot != null ? lexBot.build() : null;
        }

        @Override
        @Transient
        public final Builder lexBot(LexBot lexBot) {
            this.lexBot = lexBot;
            return this;
        }

        public final LexV2Bot.Builder getLexV2Bot() {
            return this.lexV2Bot != null ? this.lexV2Bot.toBuilder() : null;
        }

        public final void setLexV2Bot(LexV2Bot.BuilderImpl lexV2Bot) {
            this.lexV2Bot = lexV2Bot != null ? lexV2Bot.build() : null;
        }

        @Override
        @Transient
        public final Builder lexV2Bot(LexV2Bot lexV2Bot) {
            this.lexV2Bot = lexV2Bot;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateBotRequest build() {
            return new AssociateBotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateBotRequest> {
        public Builder instanceId(String var1);

        public Builder lexBot(LexBot var1);

        default public Builder lexBot(Consumer<LexBot.Builder> lexBot) {
            return this.lexBot((LexBot)((LexBot.Builder)LexBot.builder().applyMutation(lexBot)).build());
        }

        public Builder lexV2Bot(LexV2Bot var1);

        default public Builder lexV2Bot(Consumer<LexV2Bot.Builder> lexV2Bot) {
            return this.lexV2Bot((LexV2Bot)((LexV2Bot.Builder)LexV2Bot.builder().applyMutation(lexV2Bot)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

