/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Grouping {
    QUEUE("QUEUE"),
    CHANNEL("CHANNEL"),
    ROUTING_PROFILE("ROUTING_PROFILE"),
    INSTANCE("INSTANCE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Grouping> VALUE_MAP;
    private final String value;

    private Grouping(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Grouping fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Grouping> knownValues() {
        EnumSet<Grouping> knownValues = EnumSet.allOf(Grouping.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Grouping.class, Grouping::toString);
    }
}

