/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.OriginsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApprovedOriginsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListApprovedOriginsResponse> {
    private static final SdkField<List<String>> ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Origins").getter(ListApprovedOriginsResponse.getter(ListApprovedOriginsResponse::origins)).setter(ListApprovedOriginsResponse.setter(Builder::origins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApprovedOriginsResponse.getter(ListApprovedOriginsResponse::nextToken)).setter(ListApprovedOriginsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> origins;
    private final String nextToken;

    private ListApprovedOriginsResponse(BuilderImpl builder) {
        super(builder);
        this.origins = builder.origins;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOrigins() {
        return this.origins != null && !(this.origins instanceof SdkAutoConstructList);
    }

    public final List<String> origins() {
        return this.origins;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrigins() ? this.origins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApprovedOriginsResponse)) {
            return false;
        }
        ListApprovedOriginsResponse other = (ListApprovedOriginsResponse)((Object)obj);
        return this.hasOrigins() == other.hasOrigins() && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApprovedOriginsResponse").add("Origins", this.hasOrigins() ? this.origins() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Origins": {
                return Optional.ofNullable(clazz.cast(this.origins()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApprovedOriginsResponse, T> g) {
        return obj -> g.apply((ListApprovedOriginsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<String> origins = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApprovedOriginsResponse model) {
            super(model);
            this.origins(model.origins);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getOrigins() {
            if (this.origins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.origins;
        }

        public final void setOrigins(Collection<String> origins) {
            this.origins = OriginsListCopier.copy(origins);
        }

        @Override
        @Transient
        public final Builder origins(Collection<String> origins) {
            this.origins = OriginsListCopier.copy(origins);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder origins(String ... origins) {
            this.origins(Arrays.asList(origins));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApprovedOriginsResponse build() {
            return new ListApprovedOriginsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApprovedOriginsResponse> {
        public Builder origins(Collection<String> var1);

        public Builder origins(String ... var1);

        public Builder nextToken(String var1);
    }
}

