/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataRequest;
import software.amazon.awssdk.services.connect.model.GetCurrentUserDataResponse;

public class GetCurrentUserDataPublisher
implements SdkPublisher<GetCurrentUserDataResponse> {
    private final ConnectAsyncClient client;
    private final GetCurrentUserDataRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCurrentUserDataPublisher(ConnectAsyncClient client, GetCurrentUserDataRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCurrentUserDataPublisher(ConnectAsyncClient client, GetCurrentUserDataRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCurrentUserDataResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCurrentUserDataResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetCurrentUserDataResponseFetcher
    implements AsyncPageFetcher<GetCurrentUserDataResponse> {
        private GetCurrentUserDataResponseFetcher() {
        }

        public boolean hasNextPage(GetCurrentUserDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCurrentUserDataResponse> nextPage(GetCurrentUserDataResponse previousPage) {
            if (previousPage == null) {
                return GetCurrentUserDataPublisher.this.client.getCurrentUserData(GetCurrentUserDataPublisher.this.firstRequest);
            }
            return GetCurrentUserDataPublisher.this.client.getCurrentUserData((GetCurrentUserDataRequest)((Object)GetCurrentUserDataPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

