/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartChatContactResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, StartChatContactResponse> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(StartChatContactResponse.getter(StartChatContactResponse::contactId)).setter(StartChatContactResponse.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> PARTICIPANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantId").getter(StartChatContactResponse.getter(StartChatContactResponse::participantId)).setter(StartChatContactResponse.setter(Builder::participantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantId").build()}).build();
    private static final SdkField<String> PARTICIPANT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParticipantToken").getter(StartChatContactResponse.getter(StartChatContactResponse::participantToken)).setter(StartChatContactResponse.setter(Builder::participantToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, PARTICIPANT_ID_FIELD, PARTICIPANT_TOKEN_FIELD));
    private final String contactId;
    private final String participantId;
    private final String participantToken;

    private StartChatContactResponse(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.participantId = builder.participantId;
        this.participantToken = builder.participantToken;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String participantId() {
        return this.participantId;
    }

    public final String participantToken() {
        return this.participantToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChatContactResponse)) {
            return false;
        }
        StartChatContactResponse other = (StartChatContactResponse)((Object)obj);
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.participantId(), other.participantId()) && Objects.equals(this.participantToken(), other.participantToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartChatContactResponse").add("ContactId", (Object)this.contactId()).add("ParticipantId", (Object)this.participantId()).add("ParticipantToken", (Object)this.participantToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "ParticipantId": {
                return Optional.ofNullable(clazz.cast(this.participantId()));
            }
            case "ParticipantToken": {
                return Optional.ofNullable(clazz.cast(this.participantToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChatContactResponse, T> g) {
        return obj -> g.apply((StartChatContactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String contactId;
        private String participantId;
        private String participantToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChatContactResponse model) {
            super(model);
            this.contactId(model.contactId);
            this.participantId(model.participantId);
            this.participantToken(model.participantToken);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        @Transient
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getParticipantId() {
            return this.participantId;
        }

        public final void setParticipantId(String participantId) {
            this.participantId = participantId;
        }

        @Override
        @Transient
        public final Builder participantId(String participantId) {
            this.participantId = participantId;
            return this;
        }

        public final String getParticipantToken() {
            return this.participantToken;
        }

        public final void setParticipantToken(String participantToken) {
            this.participantToken = participantToken;
        }

        @Override
        @Transient
        public final Builder participantToken(String participantToken) {
            this.participantToken = participantToken;
            return this;
        }

        @Override
        public StartChatContactResponse build() {
            return new StartChatContactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartChatContactResponse> {
        public Builder contactId(String var1);

        public Builder participantId(String var1);

        public Builder participantToken(String var1);
    }
}

