/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LexVersion {
    V1("V1"),
    V2("V2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LexVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LexVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LexVersion.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LexVersion> knownValues() {
        return Stream.of(LexVersion.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

