/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.IntegrationAssociationSummary;
import software.amazon.awssdk.services.connect.model.IntegrationAssociationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIntegrationAssociationsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListIntegrationAssociationsResponse> {
    private static final SdkField<List<IntegrationAssociationSummary>> INTEGRATION_ASSOCIATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IntegrationAssociationSummaryList").getter(ListIntegrationAssociationsResponse.getter(ListIntegrationAssociationsResponse::integrationAssociationSummaryList)).setter(ListIntegrationAssociationsResponse.setter(Builder::integrationAssociationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegrationAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIntegrationAssociationsResponse.getter(ListIntegrationAssociationsResponse::nextToken)).setter(ListIntegrationAssociationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_ASSOCIATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<IntegrationAssociationSummary> integrationAssociationSummaryList;
    private final String nextToken;

    private ListIntegrationAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.integrationAssociationSummaryList = builder.integrationAssociationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIntegrationAssociationSummaryList() {
        return this.integrationAssociationSummaryList != null && !(this.integrationAssociationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<IntegrationAssociationSummary> integrationAssociationSummaryList() {
        return this.integrationAssociationSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrationAssociationSummaryList() ? this.integrationAssociationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIntegrationAssociationsResponse)) {
            return false;
        }
        ListIntegrationAssociationsResponse other = (ListIntegrationAssociationsResponse)((Object)obj);
        return this.hasIntegrationAssociationSummaryList() == other.hasIntegrationAssociationSummaryList() && Objects.equals(this.integrationAssociationSummaryList(), other.integrationAssociationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIntegrationAssociationsResponse").add("IntegrationAssociationSummaryList", this.hasIntegrationAssociationSummaryList() ? this.integrationAssociationSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegrationAssociationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.integrationAssociationSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIntegrationAssociationsResponse, T> g) {
        return obj -> g.apply((ListIntegrationAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<IntegrationAssociationSummary> integrationAssociationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIntegrationAssociationsResponse model) {
            super(model);
            this.integrationAssociationSummaryList(model.integrationAssociationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<IntegrationAssociationSummary.Builder> getIntegrationAssociationSummaryList() {
            List<IntegrationAssociationSummary.Builder> result = IntegrationAssociationSummaryListCopier.copyToBuilder(this.integrationAssociationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder integrationAssociationSummaryList(Collection<IntegrationAssociationSummary> integrationAssociationSummaryList) {
            this.integrationAssociationSummaryList = IntegrationAssociationSummaryListCopier.copy(integrationAssociationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationAssociationSummaryList(IntegrationAssociationSummary ... integrationAssociationSummaryList) {
            this.integrationAssociationSummaryList(Arrays.asList(integrationAssociationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrationAssociationSummaryList(Consumer<IntegrationAssociationSummary.Builder> ... integrationAssociationSummaryList) {
            this.integrationAssociationSummaryList(Stream.of(integrationAssociationSummaryList).map(c -> (IntegrationAssociationSummary)((IntegrationAssociationSummary.Builder)IntegrationAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIntegrationAssociationSummaryList(Collection<IntegrationAssociationSummary.BuilderImpl> integrationAssociationSummaryList) {
            this.integrationAssociationSummaryList = IntegrationAssociationSummaryListCopier.copyFromBuilder(integrationAssociationSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIntegrationAssociationsResponse build() {
            return new ListIntegrationAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIntegrationAssociationsResponse> {
        public Builder integrationAssociationSummaryList(Collection<IntegrationAssociationSummary> var1);

        public Builder integrationAssociationSummaryList(IntegrationAssociationSummary ... var1);

        public Builder integrationAssociationSummaryList(Consumer<IntegrationAssociationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

