/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.QuickConnectSummary;
import software.amazon.awssdk.services.connect.model.QuickConnectSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueueQuickConnectsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListQueueQuickConnectsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListQueueQuickConnectsResponse.getter(ListQueueQuickConnectsResponse::nextToken)).setter(ListQueueQuickConnectsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<QuickConnectSummary>> QUICK_CONNECT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QuickConnectSummaryList").getter(ListQueueQuickConnectsResponse.getter(ListQueueQuickConnectsResponse::quickConnectSummaryList)).setter(ListQueueQuickConnectsResponse.setter(Builder::quickConnectSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuickConnectSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, QUICK_CONNECT_SUMMARY_LIST_FIELD));
    private final String nextToken;
    private final List<QuickConnectSummary> quickConnectSummaryList;

    private ListQueueQuickConnectsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.quickConnectSummaryList = builder.quickConnectSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQuickConnectSummaryList() {
        return this.quickConnectSummaryList != null && !(this.quickConnectSummaryList instanceof SdkAutoConstructList);
    }

    public final List<QuickConnectSummary> quickConnectSummaryList() {
        return this.quickConnectSummaryList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuickConnectSummaryList() ? this.quickConnectSummaryList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueQuickConnectsResponse)) {
            return false;
        }
        ListQueueQuickConnectsResponse other = (ListQueueQuickConnectsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasQuickConnectSummaryList() == other.hasQuickConnectSummaryList() && Objects.equals(this.quickConnectSummaryList(), other.quickConnectSummaryList());
    }

    public final String toString() {
        return ToString.builder((String)"ListQueueQuickConnectsResponse").add("NextToken", (Object)this.nextToken()).add("QuickConnectSummaryList", this.hasQuickConnectSummaryList() ? this.quickConnectSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "QuickConnectSummaryList": {
                return Optional.ofNullable(clazz.cast(this.quickConnectSummaryList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListQueueQuickConnectsResponse, T> g) {
        return obj -> g.apply((ListQueueQuickConnectsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<QuickConnectSummary> quickConnectSummaryList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueQuickConnectsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.quickConnectSummaryList(model.quickConnectSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<QuickConnectSummary.Builder> getQuickConnectSummaryList() {
            if (this.quickConnectSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.quickConnectSummaryList != null ? (Collection)this.quickConnectSummaryList.stream().map(QuickConnectSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder quickConnectSummaryList(Collection<QuickConnectSummary> quickConnectSummaryList) {
            this.quickConnectSummaryList = QuickConnectSummaryListCopier.copy(quickConnectSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectSummaryList(QuickConnectSummary ... quickConnectSummaryList) {
            this.quickConnectSummaryList(Arrays.asList(quickConnectSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickConnectSummaryList(Consumer<QuickConnectSummary.Builder> ... quickConnectSummaryList) {
            this.quickConnectSummaryList(Stream.of(quickConnectSummaryList).map(c -> (QuickConnectSummary)((QuickConnectSummary.Builder)QuickConnectSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQuickConnectSummaryList(Collection<QuickConnectSummary.BuilderImpl> quickConnectSummaryList) {
            this.quickConnectSummaryList = QuickConnectSummaryListCopier.copyFromBuilder(quickConnectSummaryList);
        }

        @Override
        public ListQueueQuickConnectsResponse build() {
            return new ListQueueQuickConnectsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQueueQuickConnectsResponse> {
        public Builder nextToken(String var1);

        public Builder quickConnectSummaryList(Collection<QuickConnectSummary> var1);

        public Builder quickConnectSummaryList(QuickConnectSummary ... var1);

        public Builder quickConnectSummaryList(Consumer<QuickConnectSummary.Builder> ... var1);
    }
}

