/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.QuickConnectConfig;
import software.amazon.awssdk.services.connect.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuickConnect
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuickConnect> {
    private static final SdkField<String> QUICK_CONNECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuickConnectARN").getter(QuickConnect.getter(QuickConnect::quickConnectARN)).setter(QuickConnect.setter(Builder::quickConnectARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectARN").build()}).build();
    private static final SdkField<String> QUICK_CONNECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuickConnectId").getter(QuickConnect.getter(QuickConnect::quickConnectId)).setter(QuickConnect.setter(Builder::quickConnectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(QuickConnect.getter(QuickConnect::name)).setter(QuickConnect.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(QuickConnect.getter(QuickConnect::description)).setter(QuickConnect.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<QuickConnectConfig> QUICK_CONNECT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QuickConnectConfig").getter(QuickConnect.getter(QuickConnect::quickConnectConfig)).setter(QuickConnect.setter(Builder::quickConnectConfig)).constructor(QuickConnectConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickConnectConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(QuickConnect.getter(QuickConnect::tags)).setter(QuickConnect.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_CONNECT_ARN_FIELD, QUICK_CONNECT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, QUICK_CONNECT_CONFIG_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String quickConnectARN;
    private final String quickConnectId;
    private final String name;
    private final String description;
    private final QuickConnectConfig quickConnectConfig;
    private final Map<String, String> tags;

    private QuickConnect(BuilderImpl builder) {
        this.quickConnectARN = builder.quickConnectARN;
        this.quickConnectId = builder.quickConnectId;
        this.name = builder.name;
        this.description = builder.description;
        this.quickConnectConfig = builder.quickConnectConfig;
        this.tags = builder.tags;
    }

    public final String quickConnectARN() {
        return this.quickConnectARN;
    }

    public final String quickConnectId() {
        return this.quickConnectId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final QuickConnectConfig quickConnectConfig() {
        return this.quickConnectConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.quickConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuickConnect)) {
            return false;
        }
        QuickConnect other = (QuickConnect)obj;
        return Objects.equals(this.quickConnectARN(), other.quickConnectARN()) && Objects.equals(this.quickConnectId(), other.quickConnectId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.quickConnectConfig(), other.quickConnectConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"QuickConnect").add("QuickConnectARN", (Object)this.quickConnectARN()).add("QuickConnectId", (Object)this.quickConnectId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("QuickConnectConfig", (Object)this.quickConnectConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuickConnectARN": {
                return Optional.ofNullable(clazz.cast(this.quickConnectARN()));
            }
            case "QuickConnectId": {
                return Optional.ofNullable(clazz.cast(this.quickConnectId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "QuickConnectConfig": {
                return Optional.ofNullable(clazz.cast(this.quickConnectConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuickConnect, T> g) {
        return obj -> g.apply((QuickConnect)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String quickConnectARN;
        private String quickConnectId;
        private String name;
        private String description;
        private QuickConnectConfig quickConnectConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuickConnect model) {
            this.quickConnectARN(model.quickConnectARN);
            this.quickConnectId(model.quickConnectId);
            this.name(model.name);
            this.description(model.description);
            this.quickConnectConfig(model.quickConnectConfig);
            this.tags(model.tags);
        }

        public final String getQuickConnectARN() {
            return this.quickConnectARN;
        }

        @Override
        public final Builder quickConnectARN(String quickConnectARN) {
            this.quickConnectARN = quickConnectARN;
            return this;
        }

        public final void setQuickConnectARN(String quickConnectARN) {
            this.quickConnectARN = quickConnectARN;
        }

        public final String getQuickConnectId() {
            return this.quickConnectId;
        }

        @Override
        public final Builder quickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
            return this;
        }

        public final void setQuickConnectId(String quickConnectId) {
            this.quickConnectId = quickConnectId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final QuickConnectConfig.Builder getQuickConnectConfig() {
            return this.quickConnectConfig != null ? this.quickConnectConfig.toBuilder() : null;
        }

        @Override
        public final Builder quickConnectConfig(QuickConnectConfig quickConnectConfig) {
            this.quickConnectConfig = quickConnectConfig;
            return this;
        }

        public final void setQuickConnectConfig(QuickConnectConfig.BuilderImpl quickConnectConfig) {
            this.quickConnectConfig = quickConnectConfig != null ? quickConnectConfig.build() : null;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public QuickConnect build() {
            return new QuickConnect(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuickConnect> {
        public Builder quickConnectARN(String var1);

        public Builder quickConnectId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder quickConnectConfig(QuickConnectConfig var1);

        default public Builder quickConnectConfig(Consumer<QuickConnectConfig.Builder> quickConnectConfig) {
            return this.quickConnectConfig((QuickConnectConfig)((QuickConnectConfig.Builder)QuickConnectConfig.builder().applyMutation(quickConnectConfig)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

