/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserHierarchyStructureRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateUserHierarchyStructureRequest.Builder, UpdateUserHierarchyStructureRequest> {
    private static final SdkField<HierarchyStructureUpdate> HIERARCHY_STRUCTURE_FIELD = SdkField
            .<HierarchyStructureUpdate> builder(MarshallingType.SDK_POJO).memberName("HierarchyStructure")
            .getter(getter(UpdateUserHierarchyStructureRequest::hierarchyStructure)).setter(setter(Builder::hierarchyStructure))
            .constructor(HierarchyStructureUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyStructure").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateUserHierarchyStructureRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_STRUCTURE_FIELD,
            INSTANCE_ID_FIELD));

    private final HierarchyStructureUpdate hierarchyStructure;

    private final String instanceId;

    private UpdateUserHierarchyStructureRequest(BuilderImpl builder) {
        super(builder);
        this.hierarchyStructure = builder.hierarchyStructure;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The hierarchy levels to update.
     * </p>
     * 
     * @return The hierarchy levels to update.
     */
    public final HierarchyStructureUpdate hierarchyStructure() {
        return hierarchyStructure;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyStructure());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserHierarchyStructureRequest)) {
            return false;
        }
        UpdateUserHierarchyStructureRequest other = (UpdateUserHierarchyStructureRequest) obj;
        return Objects.equals(hierarchyStructure(), other.hierarchyStructure())
                && Objects.equals(instanceId(), other.instanceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserHierarchyStructureRequest").add("HierarchyStructure", hierarchyStructure())
                .add("InstanceId", instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HierarchyStructure":
            return Optional.ofNullable(clazz.cast(hierarchyStructure()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserHierarchyStructureRequest, T> g) {
        return obj -> g.apply((UpdateUserHierarchyStructureRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateUserHierarchyStructureRequest> {
        /**
         * <p>
         * The hierarchy levels to update.
         * </p>
         * 
         * @param hierarchyStructure
         *        The hierarchy levels to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyStructure(HierarchyStructureUpdate hierarchyStructure);

        /**
         * <p>
         * The hierarchy levels to update.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyStructureUpdate.Builder} avoiding the
         * need to create one manually via {@link HierarchyStructureUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyStructureUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #hierarchyStructure(HierarchyStructureUpdate)}.
         * 
         * @param hierarchyStructure
         *        a consumer that will call methods on {@link HierarchyStructureUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyStructure(HierarchyStructureUpdate)
         */
        default Builder hierarchyStructure(Consumer<HierarchyStructureUpdate.Builder> hierarchyStructure) {
            return hierarchyStructure(HierarchyStructureUpdate.builder().applyMutation(hierarchyStructure).build());
        }

        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private HierarchyStructureUpdate hierarchyStructure;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserHierarchyStructureRequest model) {
            super(model);
            hierarchyStructure(model.hierarchyStructure);
            instanceId(model.instanceId);
        }

        public final HierarchyStructureUpdate.Builder getHierarchyStructure() {
            return hierarchyStructure != null ? hierarchyStructure.toBuilder() : null;
        }

        @Override
        public final Builder hierarchyStructure(HierarchyStructureUpdate hierarchyStructure) {
            this.hierarchyStructure = hierarchyStructure;
            return this;
        }

        public final void setHierarchyStructure(HierarchyStructureUpdate.BuilderImpl hierarchyStructure) {
            this.hierarchyStructure = hierarchyStructure != null ? hierarchyStructure.build() : null;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserHierarchyStructureRequest build() {
            return new UpdateUserHierarchyStructureRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
