/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRoutingProfileDefaultOutboundQueueRequest extends ConnectRequest
        implements
        ToCopyableBuilder<UpdateRoutingProfileDefaultOutboundQueueRequest.Builder, UpdateRoutingProfileDefaultOutboundQueueRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateRoutingProfileDefaultOutboundQueueRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoutingProfileId").getter(getter(UpdateRoutingProfileDefaultOutboundQueueRequest::routingProfileId))
            .setter(setter(Builder::routingProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()).build();

    private static final SdkField<String> DEFAULT_OUTBOUND_QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultOutboundQueueId")
            .getter(getter(UpdateRoutingProfileDefaultOutboundQueueRequest::defaultOutboundQueueId))
            .setter(setter(Builder::defaultOutboundQueueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOutboundQueueId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            ROUTING_PROFILE_ID_FIELD, DEFAULT_OUTBOUND_QUEUE_ID_FIELD));

    private final String instanceId;

    private final String routingProfileId;

    private final String defaultOutboundQueueId;

    private UpdateRoutingProfileDefaultOutboundQueueRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.defaultOutboundQueueId = builder.defaultOutboundQueueId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the routing profile.
     * </p>
     * 
     * @return The identifier of the routing profile.
     */
    public final String routingProfileId() {
        return routingProfileId;
    }

    /**
     * <p>
     * The identifier for the default outbound queue.
     * </p>
     * 
     * @return The identifier for the default outbound queue.
     */
    public final String defaultOutboundQueueId() {
        return defaultOutboundQueueId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOutboundQueueId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingProfileDefaultOutboundQueueRequest)) {
            return false;
        }
        UpdateRoutingProfileDefaultOutboundQueueRequest other = (UpdateRoutingProfileDefaultOutboundQueueRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(routingProfileId(), other.routingProfileId())
                && Objects.equals(defaultOutboundQueueId(), other.defaultOutboundQueueId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRoutingProfileDefaultOutboundQueueRequest").add("InstanceId", instanceId())
                .add("RoutingProfileId", routingProfileId()).add("DefaultOutboundQueueId", defaultOutboundQueueId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "RoutingProfileId":
            return Optional.ofNullable(clazz.cast(routingProfileId()));
        case "DefaultOutboundQueueId":
            return Optional.ofNullable(clazz.cast(defaultOutboundQueueId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingProfileDefaultOutboundQueueRequest, T> g) {
        return obj -> g.apply((UpdateRoutingProfileDefaultOutboundQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRoutingProfileDefaultOutboundQueueRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the routing profile.
         * </p>
         * 
         * @param routingProfileId
         *        The identifier of the routing profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileId(String routingProfileId);

        /**
         * <p>
         * The identifier for the default outbound queue.
         * </p>
         * 
         * @param defaultOutboundQueueId
         *        The identifier for the default outbound queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOutboundQueueId(String defaultOutboundQueueId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String routingProfileId;

        private String defaultOutboundQueueId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingProfileDefaultOutboundQueueRequest model) {
            super(model);
            instanceId(model.instanceId);
            routingProfileId(model.routingProfileId);
            defaultOutboundQueueId(model.defaultOutboundQueueId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getRoutingProfileId() {
            return routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final String getDefaultOutboundQueueId() {
            return defaultOutboundQueueId;
        }

        @Override
        public final Builder defaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
            return this;
        }

        public final void setDefaultOutboundQueueId(String defaultOutboundQueueId) {
            this.defaultOutboundQueueId = defaultOutboundQueueId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingProfileDefaultOutboundQueueRequest build() {
            return new UpdateRoutingProfileDefaultOutboundQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
