/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartChatContactRequest extends ConnectRequest implements
        ToCopyableBuilder<StartChatContactRequest.Builder, StartChatContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartChatContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(StartChatContactRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(StartChatContactRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField
            .<ParticipantDetails> builder(MarshallingType.SDK_POJO).memberName("ParticipantDetails")
            .getter(getter(StartChatContactRequest::participantDetails)).setter(setter(Builder::participantDetails))
            .constructor(ParticipantDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build())
            .build();

    private static final SdkField<ChatMessage> INITIAL_MESSAGE_FIELD = SdkField.<ChatMessage> builder(MarshallingType.SDK_POJO)
            .memberName("InitialMessage").getter(getter(StartChatContactRequest::initialMessage))
            .setter(setter(Builder::initialMessage)).constructor(ChatMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialMessage").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartChatContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_FLOW_ID_FIELD, ATTRIBUTES_FIELD, PARTICIPANT_DETAILS_FIELD, INITIAL_MESSAGE_FIELD, CLIENT_TOKEN_FIELD));

    private final String instanceId;

    private final String contactFlowId;

    private final Map<String, String> attributes;

    private final ParticipantDetails participantDetails;

    private final ChatMessage initialMessage;

    private final String clientToken;

    private StartChatContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowId = builder.contactFlowId;
        this.attributes = builder.attributes;
        this.participantDetails = builder.participantDetails;
        this.initialMessage = builder.initialMessage;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect
     * console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact
     * flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow
     * information</b>. The ContactFlowId is the last part of the ARN, shown here in bold:
     * </p>
     * <p>
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     * </p>
     * 
     * @return The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon
     *         Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose
     *         the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional
     *         flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p>
     *         <p>
     *         arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     *         846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can
     * be accessed in contact flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes.
     *         They can be accessed in contact flows just like any other contact attributes. </p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * Information identifying the participant.
     * </p>
     * 
     * @return Information identifying the participant.
     */
    public final ParticipantDetails participantDetails() {
        return participantDetails;
    }

    /**
     * <p>
     * The initial message to be sent to the newly created chat.
     * </p>
     * 
     * @return The initial message to be sent to the newly created chat.
     */
    public final ChatMessage initialMessage() {
        return initialMessage;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(initialMessage());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChatContactRequest)) {
            return false;
        }
        StartChatContactRequest other = (StartChatContactRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(contactFlowId(), other.contactFlowId())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && Objects.equals(participantDetails(), other.participantDetails())
                && Objects.equals(initialMessage(), other.initialMessage()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartChatContactRequest").add("InstanceId", instanceId()).add("ContactFlowId", contactFlowId())
                .add("Attributes", hasAttributes() ? attributes() : null).add("ParticipantDetails", participantDetails())
                .add("InitialMessage", initialMessage()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ParticipantDetails":
            return Optional.ofNullable(clazz.cast(participantDetails()));
        case "InitialMessage":
            return Optional.ofNullable(clazz.cast(initialMessage()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChatContactRequest, T> g) {
        return obj -> g.apply((StartChatContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartChatContactRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon Connect
         * console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the contact
         * flow. On the contact flow page, under the name of the contact flow, choose <b>Show additional flow
         * information</b>. The ContactFlowId is the last part of the ARN, shown here in bold:
         * </p>
         * <p>
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the contact flow for initiating the chat. To see the ContactFlowId in the Amazon
         *        Connect console user interface, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>.
         *        Choose the contact flow. On the contact flow page, under the name of the contact flow, choose <b>Show
         *        additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold:
         *        </p>
         *        <p>
         *        arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         *        846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They
         * can be accessed in contact flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes.
         *        They can be accessed in contact flows just like any other contact attributes. </p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, dash, and underscore characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Information identifying the participant.
         * </p>
         * 
         * @param participantDetails
         *        Information identifying the participant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participantDetails(ParticipantDetails participantDetails);

        /**
         * <p>
         * Information identifying the participant.
         * </p>
         * This is a convenience that creates an instance of the {@link ParticipantDetails.Builder} avoiding the need to
         * create one manually via {@link ParticipantDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParticipantDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #participantDetails(ParticipantDetails)}.
         * 
         * @param participantDetails
         *        a consumer that will call methods on {@link ParticipantDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participantDetails(ParticipantDetails)
         */
        default Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return participantDetails(ParticipantDetails.builder().applyMutation(participantDetails).build());
        }

        /**
         * <p>
         * The initial message to be sent to the newly created chat.
         * </p>
         * 
         * @param initialMessage
         *        The initial message to be sent to the newly created chat.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialMessage(ChatMessage initialMessage);

        /**
         * <p>
         * The initial message to be sent to the newly created chat.
         * </p>
         * This is a convenience that creates an instance of the {@link ChatMessage.Builder} avoiding the need to create
         * one manually via {@link ChatMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChatMessage.Builder#build()} is called immediately and its result
         * is passed to {@link #initialMessage(ChatMessage)}.
         * 
         * @param initialMessage
         *        a consumer that will call methods on {@link ChatMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialMessage(ChatMessage)
         */
        default Builder initialMessage(Consumer<ChatMessage.Builder> initialMessage) {
            return initialMessage(ChatMessage.builder().applyMutation(initialMessage).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactFlowId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private ParticipantDetails participantDetails;

        private ChatMessage initialMessage;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartChatContactRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactFlowId(model.contactFlowId);
            attributes(model.attributes);
            participantDetails(model.participantDetails);
            initialMessage(model.initialMessage);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return participantDetails != null ? participantDetails.toBuilder() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        public final ChatMessage.Builder getInitialMessage() {
            return initialMessage != null ? initialMessage.toBuilder() : null;
        }

        @Override
        public final Builder initialMessage(ChatMessage initialMessage) {
            this.initialMessage = initialMessage;
            return this;
        }

        public final void setInitialMessage(ChatMessage.BuilderImpl initialMessage) {
            this.initialMessage = initialMessage != null ? initialMessage.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartChatContactRequest build() {
            return new StartChatContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
