/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoutingProfileQueuesResponse extends ConnectResponse implements
        ToCopyableBuilder<ListRoutingProfileQueuesResponse.Builder, ListRoutingProfileQueuesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRoutingProfileQueuesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RoutingProfileQueueConfigSummary>> ROUTING_PROFILE_QUEUE_CONFIG_SUMMARY_LIST_FIELD = SdkField
            .<List<RoutingProfileQueueConfigSummary>> builder(MarshallingType.LIST)
            .memberName("RoutingProfileQueueConfigSummaryList")
            .getter(getter(ListRoutingProfileQueuesResponse::routingProfileQueueConfigSummaryList))
            .setter(setter(Builder::routingProfileQueueConfigSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RoutingProfileQueueConfigSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoutingProfileQueueConfigSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoutingProfileQueueConfigSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ROUTING_PROFILE_QUEUE_CONFIG_SUMMARY_LIST_FIELD));

    private final String nextToken;

    private final List<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList;

    private ListRoutingProfileQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.routingProfileQueueConfigSummaryList = builder.routingProfileQueueConfigSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the RoutingProfileQueueConfigSummaryList property was specified by the sender (it may be empty),
     * or false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the
     * sender is the AWS service.
     */
    public final boolean hasRoutingProfileQueueConfigSummaryList() {
        return routingProfileQueueConfigSummaryList != null
                && !(routingProfileQueueConfigSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the routing profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRoutingProfileQueueConfigSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the routing profiles.
     */
    public final List<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList() {
        return routingProfileQueueConfigSummaryList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRoutingProfileQueueConfigSummaryList() ? routingProfileQueueConfigSummaryList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoutingProfileQueuesResponse)) {
            return false;
        }
        ListRoutingProfileQueuesResponse other = (ListRoutingProfileQueuesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasRoutingProfileQueueConfigSummaryList() == other.hasRoutingProfileQueueConfigSummaryList()
                && Objects.equals(routingProfileQueueConfigSummaryList(), other.routingProfileQueueConfigSummaryList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListRoutingProfileQueuesResponse")
                .add("NextToken", nextToken())
                .add("RoutingProfileQueueConfigSummaryList",
                        hasRoutingProfileQueueConfigSummaryList() ? routingProfileQueueConfigSummaryList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RoutingProfileQueueConfigSummaryList":
            return Optional.ofNullable(clazz.cast(routingProfileQueueConfigSummaryList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoutingProfileQueuesResponse, T> g) {
        return obj -> g.apply((ListRoutingProfileQueuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRoutingProfileQueuesResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the routing profiles.
         * </p>
         * 
         * @param routingProfileQueueConfigSummaryList
         *        Information about the routing profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileQueueConfigSummaryList(
                Collection<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList);

        /**
         * <p>
         * Information about the routing profiles.
         * </p>
         * 
         * @param routingProfileQueueConfigSummaryList
         *        Information about the routing profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingProfileQueueConfigSummaryList(RoutingProfileQueueConfigSummary... routingProfileQueueConfigSummaryList);

        /**
         * <p>
         * Information about the routing profiles.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RoutingProfileQueueConfigSummary>.Builder}
         * avoiding the need to create one manually via {@link List<RoutingProfileQueueConfigSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoutingProfileQueueConfigSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #routingProfileQueueConfigSummaryList(List<RoutingProfileQueueConfigSummary>)}.
         * 
         * @param routingProfileQueueConfigSummaryList
         *        a consumer that will call methods on {@link List<RoutingProfileQueueConfigSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingProfileQueueConfigSummaryList(List<RoutingProfileQueueConfigSummary>)
         */
        Builder routingProfileQueueConfigSummaryList(
                Consumer<RoutingProfileQueueConfigSummary.Builder>... routingProfileQueueConfigSummaryList);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoutingProfileQueuesResponse model) {
            super(model);
            nextToken(model.nextToken);
            routingProfileQueueConfigSummaryList(model.routingProfileQueueConfigSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RoutingProfileQueueConfigSummary.Builder> getRoutingProfileQueueConfigSummaryList() {
            if (routingProfileQueueConfigSummaryList instanceof SdkAutoConstructList) {
                return null;
            }
            return routingProfileQueueConfigSummaryList != null ? routingProfileQueueConfigSummaryList.stream()
                    .map(RoutingProfileQueueConfigSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routingProfileQueueConfigSummaryList(
                Collection<RoutingProfileQueueConfigSummary> routingProfileQueueConfigSummaryList) {
            this.routingProfileQueueConfigSummaryList = RoutingProfileQueueConfigSummaryListCopier
                    .copy(routingProfileQueueConfigSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileQueueConfigSummaryList(
                RoutingProfileQueueConfigSummary... routingProfileQueueConfigSummaryList) {
            routingProfileQueueConfigSummaryList(Arrays.asList(routingProfileQueueConfigSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingProfileQueueConfigSummaryList(
                Consumer<RoutingProfileQueueConfigSummary.Builder>... routingProfileQueueConfigSummaryList) {
            routingProfileQueueConfigSummaryList(Stream.of(routingProfileQueueConfigSummaryList)
                    .map(c -> RoutingProfileQueueConfigSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutingProfileQueueConfigSummaryList(
                Collection<RoutingProfileQueueConfigSummary.BuilderImpl> routingProfileQueueConfigSummaryList) {
            this.routingProfileQueueConfigSummaryList = RoutingProfileQueueConfigSummaryListCopier
                    .copyFromBuilder(routingProfileQueueConfigSummaryList);
        }

        @Override
        public ListRoutingProfileQueuesResponse build() {
            return new ListRoutingProfileQueuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
