/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a hierarchy structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HierarchyStructure implements SdkPojo, Serializable,
        ToCopyableBuilder<HierarchyStructure.Builder, HierarchyStructure> {
    private static final SdkField<HierarchyLevel> LEVEL_ONE_FIELD = SdkField.<HierarchyLevel> builder(MarshallingType.SDK_POJO)
            .memberName("LevelOne").getter(getter(HierarchyStructure::levelOne)).setter(setter(Builder::levelOne))
            .constructor(HierarchyLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelOne").build()).build();

    private static final SdkField<HierarchyLevel> LEVEL_TWO_FIELD = SdkField.<HierarchyLevel> builder(MarshallingType.SDK_POJO)
            .memberName("LevelTwo").getter(getter(HierarchyStructure::levelTwo)).setter(setter(Builder::levelTwo))
            .constructor(HierarchyLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelTwo").build()).build();

    private static final SdkField<HierarchyLevel> LEVEL_THREE_FIELD = SdkField.<HierarchyLevel> builder(MarshallingType.SDK_POJO)
            .memberName("LevelThree").getter(getter(HierarchyStructure::levelThree)).setter(setter(Builder::levelThree))
            .constructor(HierarchyLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelThree").build()).build();

    private static final SdkField<HierarchyLevel> LEVEL_FOUR_FIELD = SdkField.<HierarchyLevel> builder(MarshallingType.SDK_POJO)
            .memberName("LevelFour").getter(getter(HierarchyStructure::levelFour)).setter(setter(Builder::levelFour))
            .constructor(HierarchyLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelFour").build()).build();

    private static final SdkField<HierarchyLevel> LEVEL_FIVE_FIELD = SdkField.<HierarchyLevel> builder(MarshallingType.SDK_POJO)
            .memberName("LevelFive").getter(getter(HierarchyStructure::levelFive)).setter(setter(Builder::levelFive))
            .constructor(HierarchyLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LevelFive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_ONE_FIELD,
            LEVEL_TWO_FIELD, LEVEL_THREE_FIELD, LEVEL_FOUR_FIELD, LEVEL_FIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final HierarchyLevel levelOne;

    private final HierarchyLevel levelTwo;

    private final HierarchyLevel levelThree;

    private final HierarchyLevel levelFour;

    private final HierarchyLevel levelFive;

    private HierarchyStructure(BuilderImpl builder) {
        this.levelOne = builder.levelOne;
        this.levelTwo = builder.levelTwo;
        this.levelThree = builder.levelThree;
        this.levelFour = builder.levelFour;
        this.levelFive = builder.levelFive;
    }

    /**
     * <p>
     * Information about level one.
     * </p>
     * 
     * @return Information about level one.
     */
    public final HierarchyLevel levelOne() {
        return levelOne;
    }

    /**
     * <p>
     * Information about level two.
     * </p>
     * 
     * @return Information about level two.
     */
    public final HierarchyLevel levelTwo() {
        return levelTwo;
    }

    /**
     * <p>
     * Information about level three.
     * </p>
     * 
     * @return Information about level three.
     */
    public final HierarchyLevel levelThree() {
        return levelThree;
    }

    /**
     * <p>
     * Information about level four.
     * </p>
     * 
     * @return Information about level four.
     */
    public final HierarchyLevel levelFour() {
        return levelFour;
    }

    /**
     * <p>
     * Information about level five.
     * </p>
     * 
     * @return Information about level five.
     */
    public final HierarchyLevel levelFive() {
        return levelFive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(levelOne());
        hashCode = 31 * hashCode + Objects.hashCode(levelTwo());
        hashCode = 31 * hashCode + Objects.hashCode(levelThree());
        hashCode = 31 * hashCode + Objects.hashCode(levelFour());
        hashCode = 31 * hashCode + Objects.hashCode(levelFive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchyStructure)) {
            return false;
        }
        HierarchyStructure other = (HierarchyStructure) obj;
        return Objects.equals(levelOne(), other.levelOne()) && Objects.equals(levelTwo(), other.levelTwo())
                && Objects.equals(levelThree(), other.levelThree()) && Objects.equals(levelFour(), other.levelFour())
                && Objects.equals(levelFive(), other.levelFive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HierarchyStructure").add("LevelOne", levelOne()).add("LevelTwo", levelTwo())
                .add("LevelThree", levelThree()).add("LevelFour", levelFour()).add("LevelFive", levelFive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LevelOne":
            return Optional.ofNullable(clazz.cast(levelOne()));
        case "LevelTwo":
            return Optional.ofNullable(clazz.cast(levelTwo()));
        case "LevelThree":
            return Optional.ofNullable(clazz.cast(levelThree()));
        case "LevelFour":
            return Optional.ofNullable(clazz.cast(levelFour()));
        case "LevelFive":
            return Optional.ofNullable(clazz.cast(levelFive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HierarchyStructure, T> g) {
        return obj -> g.apply((HierarchyStructure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HierarchyStructure> {
        /**
         * <p>
         * Information about level one.
         * </p>
         * 
         * @param levelOne
         *        Information about level one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelOne(HierarchyLevel levelOne);

        /**
         * <p>
         * Information about level one.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevel.Builder} avoiding the need to
         * create one manually via {@link HierarchyLevel#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevel.Builder#build()} is called immediately and its
         * result is passed to {@link #levelOne(HierarchyLevel)}.
         * 
         * @param levelOne
         *        a consumer that will call methods on {@link HierarchyLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelOne(HierarchyLevel)
         */
        default Builder levelOne(Consumer<HierarchyLevel.Builder> levelOne) {
            return levelOne(HierarchyLevel.builder().applyMutation(levelOne).build());
        }

        /**
         * <p>
         * Information about level two.
         * </p>
         * 
         * @param levelTwo
         *        Information about level two.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelTwo(HierarchyLevel levelTwo);

        /**
         * <p>
         * Information about level two.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevel.Builder} avoiding the need to
         * create one manually via {@link HierarchyLevel#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevel.Builder#build()} is called immediately and its
         * result is passed to {@link #levelTwo(HierarchyLevel)}.
         * 
         * @param levelTwo
         *        a consumer that will call methods on {@link HierarchyLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelTwo(HierarchyLevel)
         */
        default Builder levelTwo(Consumer<HierarchyLevel.Builder> levelTwo) {
            return levelTwo(HierarchyLevel.builder().applyMutation(levelTwo).build());
        }

        /**
         * <p>
         * Information about level three.
         * </p>
         * 
         * @param levelThree
         *        Information about level three.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelThree(HierarchyLevel levelThree);

        /**
         * <p>
         * Information about level three.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevel.Builder} avoiding the need to
         * create one manually via {@link HierarchyLevel#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevel.Builder#build()} is called immediately and its
         * result is passed to {@link #levelThree(HierarchyLevel)}.
         * 
         * @param levelThree
         *        a consumer that will call methods on {@link HierarchyLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelThree(HierarchyLevel)
         */
        default Builder levelThree(Consumer<HierarchyLevel.Builder> levelThree) {
            return levelThree(HierarchyLevel.builder().applyMutation(levelThree).build());
        }

        /**
         * <p>
         * Information about level four.
         * </p>
         * 
         * @param levelFour
         *        Information about level four.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelFour(HierarchyLevel levelFour);

        /**
         * <p>
         * Information about level four.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevel.Builder} avoiding the need to
         * create one manually via {@link HierarchyLevel#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevel.Builder#build()} is called immediately and its
         * result is passed to {@link #levelFour(HierarchyLevel)}.
         * 
         * @param levelFour
         *        a consumer that will call methods on {@link HierarchyLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelFour(HierarchyLevel)
         */
        default Builder levelFour(Consumer<HierarchyLevel.Builder> levelFour) {
            return levelFour(HierarchyLevel.builder().applyMutation(levelFour).build());
        }

        /**
         * <p>
         * Information about level five.
         * </p>
         * 
         * @param levelFive
         *        Information about level five.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder levelFive(HierarchyLevel levelFive);

        /**
         * <p>
         * Information about level five.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyLevel.Builder} avoiding the need to
         * create one manually via {@link HierarchyLevel#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyLevel.Builder#build()} is called immediately and its
         * result is passed to {@link #levelFive(HierarchyLevel)}.
         * 
         * @param levelFive
         *        a consumer that will call methods on {@link HierarchyLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #levelFive(HierarchyLevel)
         */
        default Builder levelFive(Consumer<HierarchyLevel.Builder> levelFive) {
            return levelFive(HierarchyLevel.builder().applyMutation(levelFive).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HierarchyLevel levelOne;

        private HierarchyLevel levelTwo;

        private HierarchyLevel levelThree;

        private HierarchyLevel levelFour;

        private HierarchyLevel levelFive;

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchyStructure model) {
            levelOne(model.levelOne);
            levelTwo(model.levelTwo);
            levelThree(model.levelThree);
            levelFour(model.levelFour);
            levelFive(model.levelFive);
        }

        public final HierarchyLevel.Builder getLevelOne() {
            return levelOne != null ? levelOne.toBuilder() : null;
        }

        @Override
        public final Builder levelOne(HierarchyLevel levelOne) {
            this.levelOne = levelOne;
            return this;
        }

        public final void setLevelOne(HierarchyLevel.BuilderImpl levelOne) {
            this.levelOne = levelOne != null ? levelOne.build() : null;
        }

        public final HierarchyLevel.Builder getLevelTwo() {
            return levelTwo != null ? levelTwo.toBuilder() : null;
        }

        @Override
        public final Builder levelTwo(HierarchyLevel levelTwo) {
            this.levelTwo = levelTwo;
            return this;
        }

        public final void setLevelTwo(HierarchyLevel.BuilderImpl levelTwo) {
            this.levelTwo = levelTwo != null ? levelTwo.build() : null;
        }

        public final HierarchyLevel.Builder getLevelThree() {
            return levelThree != null ? levelThree.toBuilder() : null;
        }

        @Override
        public final Builder levelThree(HierarchyLevel levelThree) {
            this.levelThree = levelThree;
            return this;
        }

        public final void setLevelThree(HierarchyLevel.BuilderImpl levelThree) {
            this.levelThree = levelThree != null ? levelThree.build() : null;
        }

        public final HierarchyLevel.Builder getLevelFour() {
            return levelFour != null ? levelFour.toBuilder() : null;
        }

        @Override
        public final Builder levelFour(HierarchyLevel levelFour) {
            this.levelFour = levelFour;
            return this;
        }

        public final void setLevelFour(HierarchyLevel.BuilderImpl levelFour) {
            this.levelFour = levelFour != null ? levelFour.build() : null;
        }

        public final HierarchyLevel.Builder getLevelFive() {
            return levelFive != null ? levelFive.toBuilder() : null;
        }

        @Override
        public final Builder levelFive(HierarchyLevel levelFive) {
            this.levelFive = levelFive;
            return this;
        }

        public final void setLevelFive(HierarchyLevel.BuilderImpl levelFive) {
            this.levelFive = levelFive != null ? levelFive.build() : null;
        }

        @Override
        public HierarchyStructure build() {
            return new HierarchyStructure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
