/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserHierarchyStructureResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeUserHierarchyStructureResponse.Builder, DescribeUserHierarchyStructureResponse> {
    private static final SdkField<HierarchyStructure> HIERARCHY_STRUCTURE_FIELD = SdkField
            .<HierarchyStructure> builder(MarshallingType.SDK_POJO).memberName("HierarchyStructure")
            .getter(getter(DescribeUserHierarchyStructureResponse::hierarchyStructure))
            .setter(setter(Builder::hierarchyStructure)).constructor(HierarchyStructure::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyStructure").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_STRUCTURE_FIELD));

    private final HierarchyStructure hierarchyStructure;

    private DescribeUserHierarchyStructureResponse(BuilderImpl builder) {
        super(builder);
        this.hierarchyStructure = builder.hierarchyStructure;
    }

    /**
     * <p>
     * Information about the hierarchy structure.
     * </p>
     * 
     * @return Information about the hierarchy structure.
     */
    public final HierarchyStructure hierarchyStructure() {
        return hierarchyStructure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyStructure());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserHierarchyStructureResponse)) {
            return false;
        }
        DescribeUserHierarchyStructureResponse other = (DescribeUserHierarchyStructureResponse) obj;
        return Objects.equals(hierarchyStructure(), other.hierarchyStructure());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserHierarchyStructureResponse").add("HierarchyStructure", hierarchyStructure()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HierarchyStructure":
            return Optional.ofNullable(clazz.cast(hierarchyStructure()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserHierarchyStructureResponse, T> g) {
        return obj -> g.apply((DescribeUserHierarchyStructureResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUserHierarchyStructureResponse> {
        /**
         * <p>
         * Information about the hierarchy structure.
         * </p>
         * 
         * @param hierarchyStructure
         *        Information about the hierarchy structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyStructure(HierarchyStructure hierarchyStructure);

        /**
         * <p>
         * Information about the hierarchy structure.
         * </p>
         * This is a convenience that creates an instance of the {@link HierarchyStructure.Builder} avoiding the need to
         * create one manually via {@link HierarchyStructure#builder()}.
         *
         * When the {@link Consumer} completes, {@link HierarchyStructure.Builder#build()} is called immediately and its
         * result is passed to {@link #hierarchyStructure(HierarchyStructure)}.
         * 
         * @param hierarchyStructure
         *        a consumer that will call methods on {@link HierarchyStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hierarchyStructure(HierarchyStructure)
         */
        default Builder hierarchyStructure(Consumer<HierarchyStructure.Builder> hierarchyStructure) {
            return hierarchyStructure(HierarchyStructure.builder().applyMutation(hierarchyStructure).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private HierarchyStructure hierarchyStructure;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserHierarchyStructureResponse model) {
            super(model);
            hierarchyStructure(model.hierarchyStructure);
        }

        public final HierarchyStructure.Builder getHierarchyStructure() {
            return hierarchyStructure != null ? hierarchyStructure.toBuilder() : null;
        }

        @Override
        public final Builder hierarchyStructure(HierarchyStructure hierarchyStructure) {
            this.hierarchyStructure = hierarchyStructure;
            return this;
        }

        public final void setHierarchyStructure(HierarchyStructure.BuilderImpl hierarchyStructure) {
            this.hierarchyStructure = hierarchyStructure != null ? hierarchyStructure.build() : null;
        }

        @Override
        public DescribeUserHierarchyStructureResponse build() {
            return new DescribeUserHierarchyStructureResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
