/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceStorageConfigResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeInstanceStorageConfigResponse.Builder, DescribeInstanceStorageConfigResponse> {
    private static final SdkField<InstanceStorageConfig> STORAGE_CONFIG_FIELD = SdkField
            .<InstanceStorageConfig> builder(MarshallingType.SDK_POJO).memberName("StorageConfig")
            .getter(getter(DescribeInstanceStorageConfigResponse::storageConfig)).setter(setter(Builder::storageConfig))
            .constructor(InstanceStorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIG_FIELD));

    private final InstanceStorageConfig storageConfig;

    private DescribeInstanceStorageConfigResponse(BuilderImpl builder) {
        super(builder);
        this.storageConfig = builder.storageConfig;
    }

    /**
     * <p>
     * A valid storage type.
     * </p>
     * 
     * @return A valid storage type.
     */
    public final InstanceStorageConfig storageConfig() {
        return storageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStorageConfigResponse)) {
            return false;
        }
        DescribeInstanceStorageConfigResponse other = (DescribeInstanceStorageConfigResponse) obj;
        return Objects.equals(storageConfig(), other.storageConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceStorageConfigResponse").add("StorageConfig", storageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageConfig":
            return Optional.ofNullable(clazz.cast(storageConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceStorageConfigResponse, T> g) {
        return obj -> g.apply((DescribeInstanceStorageConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceStorageConfigResponse> {
        /**
         * <p>
         * A valid storage type.
         * </p>
         * 
         * @param storageConfig
         *        A valid storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfig(InstanceStorageConfig storageConfig);

        /**
         * <p>
         * A valid storage type.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceStorageConfig.Builder} avoiding the need
         * to create one manually via {@link InstanceStorageConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceStorageConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfig(InstanceStorageConfig)}.
         * 
         * @param storageConfig
         *        a consumer that will call methods on {@link InstanceStorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfig(InstanceStorageConfig)
         */
        default Builder storageConfig(Consumer<InstanceStorageConfig.Builder> storageConfig) {
            return storageConfig(InstanceStorageConfig.builder().applyMutation(storageConfig).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private InstanceStorageConfig storageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceStorageConfigResponse model) {
            super(model);
            storageConfig(model.storageConfig);
        }

        public final InstanceStorageConfig.Builder getStorageConfig() {
            return storageConfig != null ? storageConfig.toBuilder() : null;
        }

        @Override
        public final Builder storageConfig(InstanceStorageConfig storageConfig) {
            this.storageConfig = storageConfig;
            return this;
        }

        public final void setStorageConfig(InstanceStorageConfig.BuilderImpl storageConfig) {
            this.storageConfig = storageConfig != null ? storageConfig.build() : null;
        }

        @Override
        public DescribeInstanceStorageConfigResponse build() {
            return new DescribeInstanceStorageConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
