/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceAttributeResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeInstanceAttributeResponse.Builder, DescribeInstanceAttributeResponse> {
    private static final SdkField<Attribute> ATTRIBUTE_FIELD = SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
            .memberName("Attribute").getter(getter(DescribeInstanceAttributeResponse::attribute))
            .setter(setter(Builder::attribute)).constructor(Attribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD));

    private final Attribute attribute;

    private DescribeInstanceAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
    }

    /**
     * <p>
     * The type of attribute.
     * </p>
     * 
     * @return The type of attribute.
     */
    public final Attribute attribute() {
        return attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(attribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAttributeResponse)) {
            return false;
        }
        DescribeInstanceAttributeResponse other = (DescribeInstanceAttributeResponse) obj;
        return Objects.equals(attribute(), other.attribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstanceAttributeResponse").add("Attribute", attribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceAttributeResponse, T> g) {
        return obj -> g.apply((DescribeInstanceAttributeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceAttributeResponse> {
        /**
         * <p>
         * The type of attribute.
         * </p>
         * 
         * @param attribute
         *        The type of attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attribute(Attribute attribute);

        /**
         * <p>
         * The type of attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link Attribute.Builder} avoiding the need to create
         * one manually via {@link Attribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link Attribute.Builder#build()} is called immediately and its result
         * is passed to {@link #attribute(Attribute)}.
         * 
         * @param attribute
         *        a consumer that will call methods on {@link Attribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attribute(Attribute)
         */
        default Builder attribute(Consumer<Attribute.Builder> attribute) {
            return attribute(Attribute.builder().applyMutation(attribute).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private Attribute attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAttributeResponse model) {
            super(model);
            attribute(model.attribute);
        }

        public final Attribute.Builder getAttribute() {
            return attribute != null ? attribute.toBuilder() : null;
        }

        @Override
        public final Builder attribute(Attribute attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(Attribute.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        @Override
        public DescribeInstanceAttributeResponse build() {
            return new DescribeInstanceAttributeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
