/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.ContactFlowSummary;
import software.amazon.awssdk.services.connect.model.ContactFlowSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListContactFlowsResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListContactFlowsResponse> {
    private static final SdkField<List<ContactFlowSummary>> CONTACT_FLOW_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactFlowSummaryList").getter(ListContactFlowsResponse.getter(ListContactFlowsResponse::contactFlowSummaryList)).setter(ListContactFlowsResponse.setter(Builder::contactFlowSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactFlowSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListContactFlowsResponse.getter(ListContactFlowsResponse::nextToken)).setter(ListContactFlowsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FLOW_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ContactFlowSummary> contactFlowSummaryList;
    private final String nextToken;

    private ListContactFlowsResponse(BuilderImpl builder) {
        super(builder);
        this.contactFlowSummaryList = builder.contactFlowSummaryList;
        this.nextToken = builder.nextToken;
    }

    public boolean hasContactFlowSummaryList() {
        return this.contactFlowSummaryList != null && !(this.contactFlowSummaryList instanceof SdkAutoConstructList);
    }

    public List<ContactFlowSummary> contactFlowSummaryList() {
        return this.contactFlowSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactFlowsResponse)) {
            return false;
        }
        ListContactFlowsResponse other = (ListContactFlowsResponse)((Object)obj);
        return Objects.equals(this.contactFlowSummaryList(), other.contactFlowSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListContactFlowsResponse").add("ContactFlowSummaryList", this.contactFlowSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactFlowSummaryList": {
                return Optional.ofNullable(clazz.cast(this.contactFlowSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListContactFlowsResponse, T> g) {
        return obj -> g.apply((ListContactFlowsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private List<ContactFlowSummary> contactFlowSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListContactFlowsResponse model) {
            super(model);
            this.contactFlowSummaryList(model.contactFlowSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<ContactFlowSummary.Builder> getContactFlowSummaryList() {
            return this.contactFlowSummaryList != null ? (Collection)this.contactFlowSummaryList.stream().map(ContactFlowSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contactFlowSummaryList(Collection<ContactFlowSummary> contactFlowSummaryList) {
            this.contactFlowSummaryList = ContactFlowSummaryListCopier.copy(contactFlowSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowSummaryList(ContactFlowSummary ... contactFlowSummaryList) {
            this.contactFlowSummaryList(Arrays.asList(contactFlowSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactFlowSummaryList(Consumer<ContactFlowSummary.Builder> ... contactFlowSummaryList) {
            this.contactFlowSummaryList(Stream.of(contactFlowSummaryList).map(c -> (ContactFlowSummary)((ContactFlowSummary.Builder)ContactFlowSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContactFlowSummaryList(Collection<ContactFlowSummary.BuilderImpl> contactFlowSummaryList) {
            this.contactFlowSummaryList = ContactFlowSummaryListCopier.copyFromBuilder(contactFlowSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListContactFlowsResponse build() {
            return new ListContactFlowsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListContactFlowsResponse> {
        public Builder contactFlowSummaryList(Collection<ContactFlowSummary> var1);

        public Builder contactFlowSummaryList(ContactFlowSummary ... var1);

        public Builder contactFlowSummaryList(Consumer<ContactFlowSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

