/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartOutboundVoiceContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartOutboundVoiceContactRequest> {
    private static final SdkField<String> DESTINATION_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPhoneNumber").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::destinationPhoneNumber)).setter(StartOutboundVoiceContactRequest.setter(Builder::destinationPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPhoneNumber").build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::contactFlowId)).setter(StartOutboundVoiceContactRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::instanceId)).setter(StartOutboundVoiceContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::clientToken)).setter(StartOutboundVoiceContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> SOURCE_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePhoneNumber").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::sourcePhoneNumber)).setter(StartOutboundVoiceContactRequest.setter(Builder::sourcePhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePhoneNumber").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueueId").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::queueId)).setter(StartOutboundVoiceContactRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(StartOutboundVoiceContactRequest.getter(StartOutboundVoiceContactRequest::attributes)).setter(StartOutboundVoiceContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_PHONE_NUMBER_FIELD, CONTACT_FLOW_ID_FIELD, INSTANCE_ID_FIELD, CLIENT_TOKEN_FIELD, SOURCE_PHONE_NUMBER_FIELD, QUEUE_ID_FIELD, ATTRIBUTES_FIELD));
    private final String destinationPhoneNumber;
    private final String contactFlowId;
    private final String instanceId;
    private final String clientToken;
    private final String sourcePhoneNumber;
    private final String queueId;
    private final Map<String, String> attributes;

    private StartOutboundVoiceContactRequest(BuilderImpl builder) {
        super(builder);
        this.destinationPhoneNumber = builder.destinationPhoneNumber;
        this.contactFlowId = builder.contactFlowId;
        this.instanceId = builder.instanceId;
        this.clientToken = builder.clientToken;
        this.sourcePhoneNumber = builder.sourcePhoneNumber;
        this.queueId = builder.queueId;
        this.attributes = builder.attributes;
    }

    public String destinationPhoneNumber() {
        return this.destinationPhoneNumber;
    }

    public String contactFlowId() {
        return this.contactFlowId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String sourcePhoneNumber() {
        return this.sourcePhoneNumber;
    }

    public String queueId() {
        return this.queueId;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOutboundVoiceContactRequest)) {
            return false;
        }
        StartOutboundVoiceContactRequest other = (StartOutboundVoiceContactRequest)((Object)obj);
        return Objects.equals(this.destinationPhoneNumber(), other.destinationPhoneNumber()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.sourcePhoneNumber(), other.sourcePhoneNumber()) && Objects.equals(this.queueId(), other.queueId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"StartOutboundVoiceContactRequest").add("DestinationPhoneNumber", (Object)this.destinationPhoneNumber()).add("ContactFlowId", (Object)this.contactFlowId()).add("InstanceId", (Object)this.instanceId()).add("ClientToken", (Object)this.clientToken()).add("SourcePhoneNumber", (Object)this.sourcePhoneNumber()).add("QueueId", (Object)this.queueId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.destinationPhoneNumber()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SourcePhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.sourcePhoneNumber()));
            }
            case "QueueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartOutboundVoiceContactRequest, T> g) {
        return obj -> g.apply((StartOutboundVoiceContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String destinationPhoneNumber;
        private String contactFlowId;
        private String instanceId;
        private String clientToken;
        private String sourcePhoneNumber;
        private String queueId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartOutboundVoiceContactRequest model) {
            super(model);
            this.destinationPhoneNumber(model.destinationPhoneNumber);
            this.contactFlowId(model.contactFlowId);
            this.instanceId(model.instanceId);
            this.clientToken(model.clientToken);
            this.sourcePhoneNumber(model.sourcePhoneNumber);
            this.queueId(model.queueId);
            this.attributes(model.attributes);
        }

        public final String getDestinationPhoneNumber() {
            return this.destinationPhoneNumber;
        }

        @Override
        public final Builder destinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
            return this;
        }

        public final void setDestinationPhoneNumber(String destinationPhoneNumber) {
            this.destinationPhoneNumber = destinationPhoneNumber;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getSourcePhoneNumber() {
            return this.sourcePhoneNumber;
        }

        @Override
        public final Builder sourcePhoneNumber(String sourcePhoneNumber) {
            this.sourcePhoneNumber = sourcePhoneNumber;
            return this;
        }

        public final void setSourcePhoneNumber(String sourcePhoneNumber) {
            this.sourcePhoneNumber = sourcePhoneNumber;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOutboundVoiceContactRequest build() {
            return new StartOutboundVoiceContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartOutboundVoiceContactRequest> {
        public Builder destinationPhoneNumber(String var1);

        public Builder contactFlowId(String var1);

        public Builder instanceId(String var1);

        public Builder clientToken(String var1);

        public Builder sourcePhoneNumber(String var1);

        public Builder queueId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

