/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.Filters;
import software.amazon.awssdk.services.connect.model.Grouping;
import software.amazon.awssdk.services.connect.model.GroupingsCopier;
import software.amazon.awssdk.services.connect.model.HistoricalMetric;
import software.amazon.awssdk.services.connect.model.HistoricalMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricDataRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, GetMetricDataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetMetricDataRequest.getter(GetMetricDataRequest::instanceId)).setter(GetMetricDataRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetMetricDataRequest.getter(GetMetricDataRequest::startTime)).setter(GetMetricDataRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetMetricDataRequest.getter(GetMetricDataRequest::endTime)).setter(GetMetricDataRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Filters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(GetMetricDataRequest.getter(GetMetricDataRequest::filters)).setter(GetMetricDataRequest.setter(Builder::filters)).constructor(Filters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<List<String>> GROUPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groupings").getter(GetMetricDataRequest.getter(GetMetricDataRequest::groupingsAsStrings)).setter(GetMetricDataRequest.setter(Builder::groupingsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groupings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HistoricalMetric>> HISTORICAL_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HistoricalMetrics").getter(GetMetricDataRequest.getter(GetMetricDataRequest::historicalMetrics)).setter(GetMetricDataRequest.setter(Builder::historicalMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoricalMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HistoricalMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetMetricDataRequest.getter(GetMetricDataRequest::nextToken)).setter(GetMetricDataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetMetricDataRequest.getter(GetMetricDataRequest::maxResults)).setter(GetMetricDataRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, FILTERS_FIELD, GROUPINGS_FIELD, HISTORICAL_METRICS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String instanceId;
    private final Instant startTime;
    private final Instant endTime;
    private final Filters filters;
    private final List<String> groupings;
    private final List<HistoricalMetric> historicalMetrics;
    private final String nextToken;
    private final Integer maxResults;

    private GetMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.filters = builder.filters;
        this.groupings = builder.groupings;
        this.historicalMetrics = builder.historicalMetrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Filters filters() {
        return this.filters;
    }

    public List<Grouping> groupings() {
        return GroupingsCopier.copyStringToEnum(this.groupings);
    }

    public boolean hasGroupings() {
        return this.groupings != null && !(this.groupings instanceof SdkAutoConstructList);
    }

    public List<String> groupingsAsStrings() {
        return this.groupings;
    }

    public boolean hasHistoricalMetrics() {
        return this.historicalMetrics != null && !(this.historicalMetrics instanceof SdkAutoConstructList);
    }

    public List<HistoricalMetric> historicalMetrics() {
        return this.historicalMetrics;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupings() ? this.groupingsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHistoricalMetrics() ? this.historicalMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataRequest)) {
            return false;
        }
        GetMetricDataRequest other = (GetMetricDataRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.filters(), other.filters()) && this.hasGroupings() == other.hasGroupings() && Objects.equals(this.groupingsAsStrings(), other.groupingsAsStrings()) && this.hasHistoricalMetrics() == other.hasHistoricalMetrics() && Objects.equals(this.historicalMetrics(), other.historicalMetrics()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetMetricDataRequest").add("InstanceId", (Object)this.instanceId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Filters", (Object)this.filters()).add("Groupings", this.hasGroupings() ? this.groupingsAsStrings() : null).add("HistoricalMetrics", this.hasHistoricalMetrics() ? this.historicalMetrics() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Groupings": {
                return Optional.ofNullable(clazz.cast(this.groupingsAsStrings()));
            }
            case "HistoricalMetrics": {
                return Optional.ofNullable(clazz.cast(this.historicalMetrics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataRequest, T> g) {
        return obj -> g.apply((GetMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private Instant startTime;
        private Instant endTime;
        private Filters filters;
        private List<String> groupings = DefaultSdkAutoConstructList.getInstance();
        private List<HistoricalMetric> historicalMetrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.filters(model.filters);
            this.groupingsWithStrings(model.groupings);
            this.historicalMetrics(model.historicalMetrics);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Filters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Collection<String> getGroupings() {
            if (this.groupings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupings;
        }

        @Override
        public final Builder groupingsWithStrings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingsWithStrings(String ... groupings) {
            this.groupingsWithStrings(Arrays.asList(groupings));
            return this;
        }

        @Override
        public final Builder groupings(Collection<Grouping> groupings) {
            this.groupings = GroupingsCopier.copyEnumToString(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupings(Grouping ... groupings) {
            this.groupings(Arrays.asList(groupings));
            return this;
        }

        public final void setGroupings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
        }

        public final Collection<HistoricalMetric.Builder> getHistoricalMetrics() {
            if (this.historicalMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.historicalMetrics != null ? (Collection)this.historicalMetrics.stream().map(HistoricalMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder historicalMetrics(Collection<HistoricalMetric> historicalMetrics) {
            this.historicalMetrics = HistoricalMetricsCopier.copy(historicalMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalMetrics(HistoricalMetric ... historicalMetrics) {
            this.historicalMetrics(Arrays.asList(historicalMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder historicalMetrics(Consumer<HistoricalMetric.Builder> ... historicalMetrics) {
            this.historicalMetrics(Stream.of(historicalMetrics).map(c -> (HistoricalMetric)((HistoricalMetric.Builder)HistoricalMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHistoricalMetrics(Collection<HistoricalMetric.BuilderImpl> historicalMetrics) {
            this.historicalMetrics = HistoricalMetricsCopier.copyFromBuilder(historicalMetrics);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricDataRequest build() {
            return new GetMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricDataRequest> {
        public Builder instanceId(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder filters(Filters var1);

        default public Builder filters(Consumer<Filters.Builder> filters) {
            return this.filters((Filters)((Filters.Builder)Filters.builder().applyMutation(filters)).build());
        }

        public Builder groupingsWithStrings(Collection<String> var1);

        public Builder groupingsWithStrings(String ... var1);

        public Builder groupings(Collection<Grouping> var1);

        public Builder groupings(Grouping ... var1);

        public Builder historicalMetrics(Collection<HistoricalMetric> var1);

        public Builder historicalMetrics(HistoricalMetric ... var1);

        public Builder historicalMetrics(Consumer<HistoricalMetric.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

