/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfig;
import software.amazon.awssdk.services.connect.model.RoutingProfileQueueConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRoutingProfileQueuesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateRoutingProfileQueuesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateRoutingProfileQueuesRequest.getter(UpdateRoutingProfileQueuesRequest::instanceId)).setter(UpdateRoutingProfileQueuesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> ROUTING_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoutingProfileId").getter(UpdateRoutingProfileQueuesRequest.getter(UpdateRoutingProfileQueuesRequest::routingProfileId)).setter(UpdateRoutingProfileQueuesRequest.setter(Builder::routingProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RoutingProfileId").build()}).build();
    private static final SdkField<List<RoutingProfileQueueConfig>> QUEUE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueueConfigs").getter(UpdateRoutingProfileQueuesRequest.getter(UpdateRoutingProfileQueuesRequest::queueConfigs)).setter(UpdateRoutingProfileQueuesRequest.setter(Builder::queueConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoutingProfileQueueConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ROUTING_PROFILE_ID_FIELD, QUEUE_CONFIGS_FIELD));
    private final String instanceId;
    private final String routingProfileId;
    private final List<RoutingProfileQueueConfig> queueConfigs;

    private UpdateRoutingProfileQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.routingProfileId = builder.routingProfileId;
        this.queueConfigs = builder.queueConfigs;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String routingProfileId() {
        return this.routingProfileId;
    }

    public boolean hasQueueConfigs() {
        return this.queueConfigs != null && !(this.queueConfigs instanceof SdkAutoConstructList);
    }

    public List<RoutingProfileQueueConfig> queueConfigs() {
        return this.queueConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueConfigs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRoutingProfileQueuesRequest)) {
            return false;
        }
        UpdateRoutingProfileQueuesRequest other = (UpdateRoutingProfileQueuesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.routingProfileId(), other.routingProfileId()) && Objects.equals(this.queueConfigs(), other.queueConfigs());
    }

    public String toString() {
        return ToString.builder((String)"UpdateRoutingProfileQueuesRequest").add("InstanceId", (Object)this.instanceId()).add("RoutingProfileId", (Object)this.routingProfileId()).add("QueueConfigs", this.queueConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "RoutingProfileId": {
                return Optional.ofNullable(clazz.cast(this.routingProfileId()));
            }
            case "QueueConfigs": {
                return Optional.ofNullable(clazz.cast(this.queueConfigs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRoutingProfileQueuesRequest, T> g) {
        return obj -> g.apply((UpdateRoutingProfileQueuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String routingProfileId;
        private List<RoutingProfileQueueConfig> queueConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRoutingProfileQueuesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.routingProfileId(model.routingProfileId);
            this.queueConfigs(model.queueConfigs);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getRoutingProfileId() {
            return this.routingProfileId;
        }

        @Override
        public final Builder routingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
            return this;
        }

        public final void setRoutingProfileId(String routingProfileId) {
            this.routingProfileId = routingProfileId;
        }

        public final Collection<RoutingProfileQueueConfig.Builder> getQueueConfigs() {
            return this.queueConfigs != null ? (Collection)this.queueConfigs.stream().map(RoutingProfileQueueConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queueConfigs(Collection<RoutingProfileQueueConfig> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copy(queueConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(RoutingProfileQueueConfig ... queueConfigs) {
            this.queueConfigs(Arrays.asList(queueConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder> ... queueConfigs) {
            this.queueConfigs(Stream.of(queueConfigs).map(c -> (RoutingProfileQueueConfig)((RoutingProfileQueueConfig.Builder)RoutingProfileQueueConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setQueueConfigs(Collection<RoutingProfileQueueConfig.BuilderImpl> queueConfigs) {
            this.queueConfigs = RoutingProfileQueueConfigListCopier.copyFromBuilder(queueConfigs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRoutingProfileQueuesRequest build() {
            return new UpdateRoutingProfileQueuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRoutingProfileQueuesRequest> {
        public Builder instanceId(String var1);

        public Builder routingProfileId(String var1);

        public Builder queueConfigs(Collection<RoutingProfileQueueConfig> var1);

        public Builder queueConfigs(RoutingProfileQueueConfig ... var1);

        public Builder queueConfigs(Consumer<RoutingProfileQueueConfig.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

